/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.CompletionRequestor;
import org.eclipse.dltk.mod.core.IBuffer;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProblemRequestor;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceModuleInfoCache;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.AbstractSourceModule;
import org.eclipse.dltk.mod.internal.core.BecomeWorkingCopyOperation;
import org.eclipse.dltk.mod.internal.core.CommitWorkingCopyOperation;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.DiscardWorkingCopyOperation;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ReconcileWorkingCopyOperation;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.SourceModuleElementInfo;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.dltk.mod.internal.core.util.Util;

public class SourceModule
extends AbstractSourceModule
implements ISourceModule {
    private static int nextId = 1;
    private final int id = nextId++;

    public SourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner, false);
    }

    @Override
    public void becomeWorkingCopy(IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(this, false, true, null);
        if (perWorkingCopyInfo == null) {
            this.close();
            BecomeWorkingCopyOperation operation = new BecomeWorkingCopyOperation(this, problemRequestor);
            operation.runOperation(monitor);
        }
    }

    @Override
    public boolean canBeRemovedFromCache() {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBeRemovedFromCache();
    }

    @Override
    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBufferBeRemovedFromCache(buffer);
    }

    @Override
    public void close() throws ModelException {
        if (this.getPerWorkingCopyInfo() != null) {
            return;
        }
        super.close();
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor) throws ModelException {
        this.codeComplete(offset, requestor, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws ModelException {
        this.codeComplete(this, offset, requestor, owner);
    }

    @Override
    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws ModelException {
        CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
        op.runOperation(monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
        IModelElement[] elements = new IModelElement[]{this};
        this.getModel().delete(elements, force, monitor);
    }

    @Override
    public void discardWorkingCopy() throws ModelException {
        DiscardWorkingCopyOperation op = new DiscardWorkingCopyOperation(this);
        op.runOperation(null);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SourceModule)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public boolean exists() {
        if (this.getPerWorkingCopyInfo() != null) {
            return true;
        }
        return super.exists();
    }

    @Override
    public char[] getFileName() {
        return this.getPath().toOSString().toCharArray();
    }

    @Override
    public ModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return ModelManager.getModelManager().getPerWorkingCopyInfo(this, false, false, null);
    }

    @Override
    public IResource getResource() {
        ProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    @Override
    public ISourceModule getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        SourceModule workingCopy;
        if (!this.isPrimary()) {
            return this;
        }
        ModelManager manager = ModelManager.getModelManager();
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy = new SourceModule((ScriptFolder)this.getParent(), this.getElementName(), workingCopyOwner), false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, problemRequestor);
        op.runOperation(monitor);
        return workingCopy;
    }

    public boolean hasResourceChanged() {
        if (!this.isWorkingCopy()) {
            return false;
        }
        Object info = ModelManager.getModelManager().getInfo(this);
        if (info == null) {
            return false;
        }
        return ((SourceModuleElementInfo)info).timestamp != this.getResource().getModificationStamp();
    }

    @Override
    public boolean isWorkingCopy() {
        return !this.isPrimary() || this.getPerWorkingCopyInfo() != null;
    }

    @Override
    public void makeConsistent(IProgressMonitor monitor) throws ModelException {
        if (this.isConsistent()) {
            return;
        }
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        sourceModuleInfoCache.remove(this);
        this.openWhenClosed(this.createElementInfo(), monitor);
    }

    @Override
    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().move(elements, containers, null, renamings, replace, monitor);
    }

    @Override
    public void reconcile(boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws ModelException {
        if (!this.isWorkingCopy()) {
            return;
        }
        if (workingCopyOwner == null) {
            workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        }
        ReconcileWorkingCopyOperation op = new ReconcileWorkingCopyOperation(this, forceProblemDetection, workingCopyOwner);
        ModelManager manager = ModelManager.getModelManager();
        try {
            manager.cacheZipFiles();
            op.runOperation(monitor);
        }
        finally {
            manager.flushZipFiles();
        }
    }

    @Override
    public void rename(String newName, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Messages.operation_nullName);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] dests = new IModelElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        this.getModel().rename(elements, dests, renamings, replace, monitor);
    }

    @Override
    public void save(IProgressMonitor pm, boolean force) throws ModelException {
        if (this.isWorkingCopy()) {
            throw new RuntimeException("not implemented");
        }
        super.save(pm, force);
    }

    @Override
    protected boolean preventReopen() {
        return super.preventReopen() && this.getPerWorkingCopyInfo() == null;
    }

    @Override
    protected String getNatureId() throws CoreException {
        IResource resource = this.getResource();
        Object lookup = resource == null ? this.getPath() : resource;
        IDLTKLanguageToolkit lookupLanguageToolkit = this.lookupLanguageToolkit(lookup);
        if (lookupLanguageToolkit == null) {
            return null;
        }
        return lookupLanguageToolkit.getNatureId();
    }

    @Override
    protected void closing(Object info) {
        if (this.getPerWorkingCopyInfo() == null) {
            super.closing(info);
        }
    }

    @Override
    protected char[] getBufferContent() throws ModelException {
        IFile file = (IFile)this.getResource();
        if (file == null || !file.exists()) {
            return CharOperation.NO_CHAR;
        }
        return Util.getResourceContentsAsCharArray(file);
    }

    @Override
    protected String getModuleType() {
        return "DLTK Source Module: ";
    }

    @Override
    protected ISourceModule getOriginalSourceModule() {
        return new SourceModule((ScriptFolder)this.getParent(), this.getElementName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    protected void updateTimeStamp(SourceModule original) throws ModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new ModelException(new ModelStatus(995));
        }
        ((SourceModuleElementInfo)this.getElementInfo()).timestamp = timeStamp;
    }
}

