/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.mixin;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.mod.core.search.indexing.IndexManager;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.mixin.Messages;
import org.eclipse.dltk.mod.internal.core.mixin.MixinExternalProjectFragmentRequest;
import org.eclipse.dltk.mod.internal.core.mixin.MixinProjectRequest;
import org.eclipse.dltk.mod.internal.core.mixin.MixinReconcileSourceModuleRequest;
import org.eclipse.dltk.mod.internal.core.mixin.MixinSourceModuleRemoveRequest;
import org.eclipse.dltk.mod.internal.core.mixin.MixinSourceModuleRequest;
import org.eclipse.dltk.mod.internal.core.mixin.RemoveIndexRequest;
import org.eclipse.dltk.mod.internal.core.search.processing.IJob;
import org.eclipse.osgi.util.NLS;

public class MixinProjectIndexer
implements IProjectIndexer {
    private final IndexManager manager = ModelManager.getModelManager().getIndexManager();

    private void request(IJob job) {
        this.manager.request(job);
    }

    private void requestIfNotWaiting(IJob job) {
        if (!this.manager.isJobWaiting(job)) {
            this.manager.request(job);
        }
    }

    @Override
    public void indexProject(IScriptProject project) {
        MixinProjectRequest request = new MixinProjectRequest(project, true);
        this.requestIfNotWaiting(request);
    }

    @Override
    public void indexLibrary(IScriptProject project, IPath path) {
        try {
            IProjectFragment fragment = project.findProjectFragment(path);
            if (fragment != null) {
                if (!path.segment(0).equals("#special#builtin#")) {
                    MixinExternalProjectFragmentRequest request = new MixinExternalProjectFragmentRequest(fragment, DLTKLanguageManager.getLanguageToolkit(fragment));
                    this.requestIfNotWaiting(request);
                }
            } else {
                DLTKCore.warn(NLS.bind((String)Messages.MixinIndexer_unknownProjectFragment, (Object)path));
            }
        }
        catch (Exception e) {
            DLTKCore.error(NLS.bind((String)Messages.MixinIndexer_indexLibraryError, (Object)path), e);
        }
    }

    @Override
    public void indexProjectFragment(IScriptProject project, IPath path) {
        this.requestIfNotWaiting(new MixinProjectRequest(project, false));
    }

    @Override
    public void indexSourceModule(ISourceModule module, IDLTKLanguageToolkit toolkit) {
        this.request(new MixinSourceModuleRequest(module, toolkit));
    }

    @Override
    public void reconciled(ISourceModule workingCopy, IDLTKLanguageToolkit toolkit) {
        this.request(new MixinReconcileSourceModuleRequest(workingCopy, toolkit));
    }

    @Override
    public void removeProjectFragment(IScriptProject project, IPath sourceFolder) {
        this.requestIfNotWaiting(new MixinProjectRequest(project, false));
    }

    @Override
    public void removeSourceModule(IScriptProject project, String path) {
        this.request(new MixinSourceModuleRemoveRequest(project, path));
    }

    @Override
    public void removeProject(IPath projectPath) {
        this.requestIfNotWaiting(new RemoveIndexRequest((IPath)new Path("#special#mixin#" + projectPath.toString())));
    }

    @Override
    public void removeLibrary(IScriptProject project, IPath path) {
        this.requestIfNotWaiting(new RemoveIndexRequest((IPath)new Path("#special#mixin#" + path.toString())));
    }

    @Override
    public void startIndexing() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            IScriptProject[] projects = DLTKCore.create(workspace.getRoot()).getScriptProjects();
            int i = 0;
            while (i < projects.length) {
                this.requestIfNotWaiting(new MixinProjectRequest(projects[i], false));
                ++i;
            }
        }
        catch (Exception e) {
            DLTKCore.error(Messages.MixinIndexer_startIndexingError, e);
        }
    }
}

