/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.breakpoints;

import org.eclipse.dltk.mod.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.mod.dbgp.internal.breakpoints.Messages;

public class DbgpBreakpoint
implements IDbgpBreakpoint {
    private final String id;
    private final boolean enabled;
    private final int hitCount;
    private final int hitValue;
    private final int hitCondition;

    protected int convertHitCondition(String s) {
        if (">=".equals(s)) {
            return 0;
        }
        if ("==".equals(s)) {
            return 1;
        }
        if ("%".equals(s)) {
            return 2;
        }
        if ("".equals(s)) {
            return -1;
        }
        throw new IllegalArgumentException(Messages.DbgpBreakpoint_invalidHitConditionValue);
    }

    public DbgpBreakpoint(String id, boolean enabled, int hitValue, int hitCount, String hitCondition) {
        this.id = id;
        this.enabled = enabled;
        this.hitValue = hitValue;
        this.hitCount = hitCount;
        this.hitCondition = this.convertHitCondition(hitCondition);
    }

    @Override
    public int getHitCondition() {
        return this.hitCondition;
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public int getHitValue() {
        return this.hitValue;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

