/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ListenerList;

public class WorkspaceTracker {
    public static final WorkspaceTracker INSTANCE = new WorkspaceTracker();
    private ListenerList fListeners = new ListenerList();
    private ResourceListener fResourceListener;

    private WorkspaceTracker() {
    }

    private void workspaceChanged() {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((Listener)listeners[i]).workspaceChanged();
            ++i;
        }
    }

    public void addListener(Listener l) {
        this.fListeners.add((Object)l);
        if (this.fResourceListener == null) {
            this.fResourceListener = new ResourceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fResourceListener);
        }
    }

    public void removeListener(Listener l) {
        if (this.fListeners.size() == 0) {
            return;
        }
        this.fListeners.remove((Object)l);
        if (this.fListeners.size() == 0) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fResourceListener);
            this.fResourceListener = null;
        }
    }

    public static interface Listener {
        public void workspaceChanged();
    }

    private class ResourceListener
    implements IResourceChangeListener {
        private ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            WorkspaceTracker.this.workspaceChanged();
        }
    }
}

