/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.rename;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKContentTypeManager;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.internal.corext.refactoring.Checks;
import org.eclipse.dltk.mod.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.mod.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.mod.internal.corext.refactoring.ScriptRefactoringArguments;
import org.eclipse.dltk.mod.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.mod.internal.corext.refactoring.ScriptRefactoringDescriptorComment;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.RenameSourceModuleChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.dltk.mod.internal.corext.refactoring.participants.ScriptProcessors;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.ScriptRenameProcessor;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public class RenameSourceModuleProcessor
extends ScriptRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper {
    private static final String ID_RENAME_COMPILATION_UNIT = "org.eclipse.dltk.mod.ui.rename.sourcemodule";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_NAME = "name";
    private ISourceModule fCu;
    public static final String IDENTIFIER = "org.eclipse.dltk.mod.ui.renameSourceModulerocessor";

    public RenameSourceModuleProcessor(ISourceModule unit) throws CoreException {
        this.fCu = unit;
        if (this.fCu != null) {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(this.fCu.getElementName());
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fCu);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameSourceModuleRefactoring_name;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return ScriptProcessors.computeAffectedNatures((IModelElement)this.fCu);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fCu};
    }

    @Override
    protected RenameModifications computeRenameModifications() {
        RenameModifications result = new RenameModifications();
        result.rename(this.fCu, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add type renaming here if required...");
        }
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        IFile file = ResourceUtil.getFile(this.fCu);
        if (file != null) {
            return new IFile[]{file};
        }
        return new IFile[0];
    }

    @Override
    public String getCurrentElementName() {
        return this.getSimpleCUName();
    }

    @Override
    public String getCurrentElementQualifier() {
        IScriptFolder pack = (IScriptFolder)this.fCu.getParent();
        return pack.getElementName();
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add correct name cheking here...");
        }
        RefactoringStatus result = new RefactoringStatus();
        if (Checks.isAlreadyNamed((IModelElement)this.fCu, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameSourceModuleRefactoring_same_name);
        }
        return result;
    }

    @Override
    public void setNewElementName(String newName) {
        super.setNewElementName(newName);
    }

    @Override
    public Object getNewElement() {
        IModelElement parent = this.fCu.getParent();
        if (parent.getElementType() != 4) {
            return this.fCu;
        }
        IScriptFolder pack = (IScriptFolder)parent;
        IDLTKLanguageToolkit tk = null;
        tk = DLTKLanguageManager.getLanguageToolkit((IModelElement)pack);
        if (tk != null && !DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)tk, (String)this.getNewElementName())) {
            return this.fCu;
        }
        return pack.getSourceModule(this.getNewElementName());
    }

    @Override
    public boolean canEnableTextUpdating() {
        return false;
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return false;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
    }

    @Override
    public boolean canEnableUpdateReferences() {
        return false;
    }

    @Override
    public void setUpdateReferences(boolean update) {
    }

    @Override
    public boolean getUpdateReferences() {
        return false;
    }

    @Override
    public boolean canEnableQualifiedNameUpdating() {
        return false;
    }

    @Override
    public boolean getUpdateQualifiedNames() {
        return false;
    }

    @Override
    public void setUpdateQualifiedNames(boolean update) {
    }

    @Override
    public String getFilePatterns() {
        return null;
    }

    @Override
    public void setFilePatterns(String patterns) {
    }

    @Override
    public boolean canEnableSimilarDeclarationUpdating() {
        return false;
    }

    @Override
    public void setUpdateSimilarDeclarations(boolean update) {
    }

    @Override
    public boolean getUpdateSimilarDeclarations() {
        return false;
    }

    @Override
    public int getMatchStrategy() {
        return 1;
    }

    @Override
    public void setMatchStrategy(int selectedStrategy) {
    }

    public IModelElement[] getSimilarElements() {
        return null;
    }

    public IResource getRefactoredResource(IResource element) {
        return element;
    }

    public IModelElement getRefactoredScriptElement(IModelElement element) {
        return element;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            RefactoringStatus refactoringStatus = Checks.checkSourceModuleNewName(this.fCu, this.getNewElementName());
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    protected void computeRenameTypeRefactoring() throws CoreException {
        if (this.getSimpleCUName().indexOf(".") != -1) {
            return;
        }
    }

    private String getSimpleCUName() {
        return RenameSourceModuleProcessor.removeFileNameExtension(this.fCu.getElementName());
    }

    private static String removeFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        IScriptFolder fragment;
        String newName = this.getNewElementName();
        IResource resource = ResourceUtil.getResource(this.fCu);
        if (resource != null && resource.isLinked()) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            IProject project = resource.getProject();
            String name = project.getName();
            String description = Messages.format(RefactoringCoreMessages.RenameSourceModuleChange_descriptor_description_short, resource.getName());
            String header = Messages.format(RefactoringCoreMessages.RenameSourceModuleChange_descriptor_description, new String[]{resource.getFullPath().toString(), newName});
            String comment = new ScriptRefactoringDescriptorComment(this, header).asString();
            ScriptRefactoringDescriptor descriptor = new ScriptRefactoringDescriptor("org.eclipse.dltk.mod.ui.rename.resource", name, description, comment, arguments, 7);
            arguments.put("input", ScriptRefactoringDescriptor.resourceToHandle(name, resource));
            arguments.put(ATTRIBUTE_NAME, newName);
            return new DynamicValidationStateChange(new RenameResourceChange(descriptor, resource, newName, comment));
        }
        String label = null;
        label = this.fCu != null ? (!(fragment = (IScriptFolder)this.fCu.getParent()).isRootFolder() ? String.valueOf(fragment.getElementName()) + "." + this.fCu.getElementName() : this.fCu.getElementName()) : this.fCu.getElementName();
        HashMap<String, String> arguments = new HashMap<String, String>();
        String name = this.fCu.getScriptProject().getElementName();
        String description = Messages.format(RefactoringCoreMessages.RenameSourceModuleChange_descriptor_description_short, this.fCu.getElementName());
        String header = Messages.format(RefactoringCoreMessages.RenameSourceModuleChange_descriptor_description, new String[]{label, newName});
        String comment = new ScriptRefactoringDescriptorComment(this, header).asString();
        ScriptRefactoringDescriptor descriptor = new ScriptRefactoringDescriptor(ID_RENAME_COMPILATION_UNIT, name, description, comment, arguments, 589830);
        arguments.put("input", descriptor.elementToHandle((IModelElement)this.fCu));
        arguments.put(ATTRIBUTE_NAME, newName);
        return new DynamicValidationStateChange(new RenameSourceModuleChange(descriptor, this.fCu, newName, comment));
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        return super.postCreateChange(participantChanges, pm);
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String name;
        if (arguments instanceof ScriptRefactoringArguments) {
            ScriptRefactoringArguments generic = (ScriptRefactoringArguments)arguments;
            String path = generic.getAttribute(ATTRIBUTE_PATH);
            if (path != null) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (resource == null || !resource.exists()) {
                    return ScriptableRefactoring.createInputFatalStatus(resource, this.getRefactoring().getName(), ID_RENAME_COMPILATION_UNIT);
                }
                this.fCu = (ISourceModule)DLTKCore.create((IResource)resource);
                try {
                    this.computeRenameTypeRefactoring();
                }
                catch (CoreException exception) {
                    DLTKUIPlugin.log(exception);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PATH));
            }
            name = generic.getAttribute(ATTRIBUTE_NAME);
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_NAME));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setNewElementName(name);
        return new RefactoringStatus();
    }
}

