/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.util;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.search.SearchEngine;
import org.eclipse.dltk.mod.core.search.SearchMatch;
import org.eclipse.dltk.mod.core.search.SearchParticipant;
import org.eclipse.dltk.mod.core.search.SearchPattern;

public class SearchUtils {
    public static final int GENERICS_AGNOSTIC_MATCH_RULE = 24;

    public static IModelElement getEnclosingModelElement(SearchMatch match) {
        Object element = match.getElement();
        if (element instanceof IModelElement) {
            return (IModelElement)element;
        }
        return null;
    }

    public static ISourceModule getSourceModule(SearchMatch match) {
        IModelElement jElement;
        IModelElement enclosingElement = SearchUtils.getEnclosingModelElement(match);
        if (enclosingElement != null) {
            if (enclosingElement instanceof ISourceModule) {
                return (ISourceModule)enclosingElement;
            }
            ISourceModule cu = (ISourceModule)enclosingElement.getAncestor(5);
            if (cu != null) {
                return cu;
            }
        }
        if ((jElement = DLTKCore.create((IResource)match.getResource())) != null && jElement.exists() && jElement.getElementType() == 5) {
            return (ISourceModule)jElement;
        }
        return null;
    }

    public static SearchParticipant[] getDefaultSearchParticipants() {
        return new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
    }

    public static boolean isCamelCasePattern(String pattern) {
        return SearchPattern.validateMatchRule((String)pattern, (int)128) == 128;
    }
}

