/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.actions;

import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.DeleteAction;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.PasteAction;
import org.eclipse.dltk.mod.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class CCPActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private Clipboard fClipboard;
    private SelectionDispatchAction[] fActions;
    private SelectionDispatchAction fDeleteAction;
    private SelectionDispatchAction fCopyAction;
    private SelectionDispatchAction fPasteAction;

    public CCPActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    public CCPActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    private CCPActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fClipboard = new Clipboard(site.getShell().getDisplay());
        this.fPasteAction = new PasteAction(this.fSite, this.fClipboard);
        this.fPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.fCopyAction = new CopyToClipboardAction(this.fSite, this.fClipboard, this.fPasteAction);
        this.fCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fDeleteAction = new DeleteAction(this.fSite);
        this.fDeleteAction.setId("org.eclipse.ui.edit.delete");
        this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.fActions = new SelectionDispatchAction[]{this.fCopyAction, this.fPasteAction, this.fDeleteAction};
        this.registerActionsAsSelectionChangeListeners();
    }

    private void registerActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        int i = 0;
        while (i < this.fActions.length) {
            SelectionDispatchAction action = this.fActions[i];
            action.update(selection);
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
            ++i;
        }
    }

    private void deregisterActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        int i = 0;
        while (i < this.fActions.length) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fActions[i]);
            ++i;
        }
    }

    public IAction getDeleteAction() {
        return this.fDeleteAction;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fPasteAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        int i = 0;
        while (i < this.fActions.length) {
            SelectionDispatchAction action = this.fActions[i];
            menu.appendToGroup("group.edit", (IAction)action);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        this.deregisterActionsAsSelectionChangeListeners();
    }
}

