/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.actions.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.ReorgMoveAction;
import org.eclipse.dltk.mod.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.mod.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.mod.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;

public class MoveAction
extends SelectionDispatchAction {
    private ScriptEditor fEditor;
    private ReorgMoveAction fReorgMoveAction;

    public MoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.MoveAction_text);
        this.fReorgMoveAction = new ReorgMoveAction(site);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public MoveAction(ScriptEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(RefactoringMessages.MoveAction_text);
        this.fReorgMoveAction = new ReorgMoveAction((IWorkbenchSite)editor.getEditorSite());
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        this.fReorgMoveAction.selectionChanged(event);
        this.setEnabled(this.computeEnableState());
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (this.fReorgMoveAction.isEnabled()) {
            this.fReorgMoveAction.run();
        }
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
                return;
            }
            if (this.tryReorgMove(selection)) {
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.MoveAction_Move, (String)RefactoringMessages.MoveAction_select);
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private boolean tryReorgMove(ITextSelection selection) throws ModelException {
        IModelElement element = SelectionConverter.getElementAtOffset((IEditorPart)this.fEditor);
        if (element == null) {
            return false;
        }
        StructuredSelection mockStructuredSelection = new StructuredSelection((Object)element);
        this.fReorgMoveAction.selectionChanged((IStructuredSelection)mockStructuredSelection);
        if (!this.fReorgMoveAction.isEnabled()) {
            return false;
        }
        this.fReorgMoveAction.run((IStructuredSelection)mockStructuredSelection);
        return true;
    }

    @Override
    public void update(ISelection selection) {
        this.fReorgMoveAction.update(selection);
        this.setEnabled(this.computeEnableState());
    }

    private boolean computeEnableState() {
        return this.fReorgMoveAction.isEnabled();
    }
}

