/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.dltk.mod.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.ArchiveFileFilter;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.BuildpathContainerWizard;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.MultipleFolderSelectionDialog;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.environment.IEnvironmentUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public final class BuildpathDialogAccess {
    private BuildpathDialogAccess() {
    }

    public static IBuildpathEntry configureContainerEntry(Shell shell, IBuildpathEntry initialEntry, IScriptProject project, IBuildpathEntry[] currentBuildpath) {
        IBuildpathEntry[] created;
        if (initialEntry == null || currentBuildpath == null) {
            throw new IllegalArgumentException();
        }
        BuildpathContainerWizard wizard = new BuildpathContainerWizard(initialEntry, project, currentBuildpath);
        if (BuildpathContainerWizard.openWizard(shell, wizard) == 0 && (created = wizard.getNewEntries()) != null && created.length == 1) {
            return created[0];
        }
        return null;
    }

    public static IBuildpathEntry[] chooseContainerEntries(Shell shell, IScriptProject project, IBuildpathEntry[] currentBuildpath) {
        if (currentBuildpath == null) {
            throw new IllegalArgumentException();
        }
        BuildpathContainerWizard wizard = new BuildpathContainerWizard(null, project, currentBuildpath);
        if (BuildpathContainerWizard.openWizard(shell, wizard) == 0) {
            return wizard.getNewEntries();
        }
        return null;
    }

    public static IPath configureArchiveEntry(Shell shell, IPath initialEntry, IPath[] usedEntries) {
        if (initialEntry == null || usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource;
            IPath curr = usedEntries[i];
            if (!curr.equals((Object)initialEntry) && (resource = root.findMember(usedEntries[i])) instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource existing = root.findMember(initialEntry);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(NewWizardMessages.BuildPathDialogAccess_ZIPArchiveDialog_edit_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_ZIPArchiveDialog_edit_description);
        dialog.addFilter((ViewerFilter)new ArchiveFileFilter(usedJars, true));
        dialog.setInput((Object)root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)existing);
        if (dialog.open() == 0) {
            IResource element = (IResource)dialog.getFirstResult();
            return element.getFullPath();
        }
        return null;
    }

    public static IPath[] chooseArchiveEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(NewWizardMessages.BuildPathDialogAccess_ZIPArchiveDialog_new_title);
        dialog.setMessage(NewWizardMessages.BuildPathDialogAccess_ZIPArchiveDialog_new_description);
        dialog.addFilter((ViewerFilter)new ArchiveFileFilter(usedJars, true));
        dialog.setInput((Object)root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }

    public static IPath configureExternalArchiveEntry(Shell shell, IPath initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        String lastUsedPath = initialEntry.removeLastSegments(1).toOSString();
        FileDialog dialog = new FileDialog(shell, 4);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtZIPArchiveDialog_edit_title);
        dialog.setFilterExtensions(ArchiveFileFilter.FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        dialog.setFileName(initialEntry.lastSegment());
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        DLTKUIPlugin.getDefault().getDialogSettings().put("org.eclipse.dltk.mod.ui.lastextzip", dialog.getFilterPath());
        return Path.fromOSString((String)res).makeAbsolute();
    }

    public static IPath[] chooseExternalArchiveEntries(Shell shell, IEnvironment environment) {
        IEnvironmentUI ui = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
        String res = ui.selectFile(shell, 2);
        if (res == null) {
            return null;
        }
        IPath[] elems = new IPath[]{new Path(res)};
        return elems;
    }

    public static IPath[] chooseSourceFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = NewWizardMessages.BuildPathDialogAccess_ExistingClassFolderDialog_new_title;
        String message = NewWizardMessages.BuildPathDialogAccess_ExistingClassFolderDialog_new_description;
        return BuildpathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    public static IPath[] chooseExtSourceFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries, IEnvironment environment) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = NewWizardMessages.BuildPathDialogAccess_ExistingClassFolderDialog_new_title;
        String message = NewWizardMessages.BuildPathDialogAccess_ExistingClassFolderDialog_new_description;
        return BuildpathDialogAccess.internalExtChooseFolderEntry(shell, initialSelection, usedEntries, title, message, environment);
    }

    private static IPath[] internalChooseFolderEntry(Shell shell, IPath initialSelection, IPath[] usedEntries, String title, String message) {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        ArrayList<IResource> usedContainers = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IContainer) {
                usedContainers.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        Object[] used = usedContainers.toArray();
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setExisting(used);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setHelpAvailable(false);
        dialog.addFilter(new TypedViewerFilter(acceptedClasses, used));
        dialog.setInput(root);
        dialog.setInitialFocus(focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }

    private static IPath[] internalExtChooseFolderEntry(Shell shell, IPath initialSelection, IPath[] usedEntries, String title, String message, IEnvironment environment) {
        IEnvironmentUI ui = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
        String res = ui.selectFolder(shell);
        if (res == null) {
            return null;
        }
        IPath[] elems = new IPath[]{EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)new Path(res))};
        return elems;
    }
}

