/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.internal.ui.util.CoreUtility;
import org.eclipse.dltk.mod.internal.ui.wizards.IBuildpathContainerPage;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.BuildpathContainerDefaultPage;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;

public class BuildpathContainerDescriptor {
    private IConfigurationElement fConfigElement;
    private IBuildpathContainerPage fPage;
    private static final String ATT_EXTENSION = "buildpathContainerPage";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_PAGE_CLASS = "class";
    private static final String ATT_NATURE = "nature";

    public BuildpathContainerDescriptor(IConfigurationElement configElement) throws CoreException {
        this.fConfigElement = configElement;
        this.fPage = null;
        String id = this.fConfigElement.getAttribute(ATT_ID);
        String name = configElement.getAttribute(ATT_NAME);
        String pageClassName = configElement.getAttribute(ATT_PAGE_CLASS);
        String nature = configElement.getAttribute(ATT_NATURE);
        if (name == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.mod.ui", 0, "Invalid extension (missing name): " + id, null));
        }
        if (nature == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.mod.ui", 0, "Invalid extension (missing nature): " + nature, null));
        }
        if (pageClassName == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.mod.ui", 0, "Invalid extension (missing page class name): " + id, null));
        }
    }

    public IBuildpathContainerPage createPage() throws CoreException {
        if (this.fPage == null) {
            Object elem = CoreUtility.createExtension(this.fConfigElement, ATT_PAGE_CLASS);
            if (elem instanceof IBuildpathContainerPage) {
                this.fPage = (IBuildpathContainerPage)elem;
            } else {
                String id = this.fConfigElement.getAttribute(ATT_ID);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.mod.ui", 0, "Invalid extension (page not of type IBuildpathContainerPage): " + id, null));
            }
        }
        return this.fPage;
    }

    public IBuildpathContainerPage getPage() {
        return this.fPage;
    }

    public void setPage(IBuildpathContainerPage page) {
        this.fPage = page;
    }

    public void dispose() {
        if (this.fPage != null) {
            this.fPage.dispose();
            this.fPage = null;
        }
    }

    public String getName() {
        return this.fConfigElement.getAttribute(ATT_NAME);
    }

    public String getPageClass() {
        return this.fConfigElement.getAttribute(ATT_PAGE_CLASS);
    }

    public String getNature() {
        return this.fConfigElement.getAttribute(ATT_NATURE);
    }

    public boolean canEdit(IBuildpathEntry entry, String defid) {
        String id = this.fConfigElement.getAttribute(ATT_ID);
        return id.equals(defid);
    }

    public boolean canEdit(IBuildpathEntry entry) {
        String id = this.fConfigElement.getAttribute(ATT_ID);
        if (entry.getEntryKind() == 5) {
            String type = entry.getPath().segment(0);
            return id.equals(type);
        }
        return false;
    }

    public static BuildpathContainerDescriptor[] getDescriptors() {
        return BuildpathContainerDescriptor.getDescriptors(null);
    }

    public static BuildpathContainerDescriptor[] getDescriptors(IScriptProject proj) {
        ArrayList<BuildpathContainerDescriptor> containers = new ArrayList<BuildpathContainerDescriptor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.mod.ui", ATT_EXTENSION);
        if (extensionPoint != null) {
            BuildpathContainerDescriptor defaultPage = null;
            String defaultPageName = BuildpathContainerDefaultPage.class.getName();
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                try {
                    BuildpathContainerDescriptor curr = new BuildpathContainerDescriptor(elements[i]);
                    if (defaultPageName.equals(curr.getPageClass())) {
                        defaultPage = curr;
                    } else if (proj == null || proj.getProject().hasNature(curr.getNature())) {
                        containers.add(curr);
                    }
                }
                catch (CoreException e) {
                    DLTKUIPlugin.log(e);
                }
                ++i;
            }
            if (defaultPageName != null && containers.isEmpty() && defaultPage != null) {
                containers.add(defaultPage);
            }
        }
        return containers.toArray(new BuildpathContainerDescriptor[containers.size()]);
    }
}

