/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.actions.FindDeclarationsAction;
import org.eclipse.dltk.mod.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.mod.ui.search.QuerySpecification;
import org.eclipse.ui.IWorkbenchSite;

public abstract class FindDeclarationsInProjectAction
extends FindDeclarationsAction {
    public FindDeclarationsInProjectAction(IWorkbenchSite site) {
        super(site);
    }

    public FindDeclarationsInProjectAction(ScriptEditor editor) {
        super(editor);
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindDeclarationsInProjectAction_label);
        this.setToolTipText(SearchMessages.Search_FindDeclarationsInProjectAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_OBJS_SEARCH_DECL);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add help support here...");
        }
    }

    @Override
    QuerySpecification createQuery(IModelElement element) throws ModelException {
        String description;
        IDLTKSearchScope scope;
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        ScriptEditor editor = this.getEditor();
        boolean isInsideInterpreterEnvironment = true;
        if (editor != null) {
            scope = factory.createProjectSearchScope(editor.getEditorInput(), isInsideInterpreterEnvironment);
            description = factory.getProjectScopeDescription(editor.getEditorInput(), isInsideInterpreterEnvironment);
        } else {
            scope = factory.createProjectSearchScope(element.getScriptProject(), isInsideInterpreterEnvironment);
            description = factory.getProjectScopeDescription(element.getScriptProject(), isInsideInterpreterEnvironment);
        }
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

