/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.actions.FindAction;
import org.eclipse.dltk.mod.ui.actions.FindReferencesAction;
import org.eclipse.dltk.mod.ui.actions.FindReferencesInHierarchyAction;
import org.eclipse.dltk.mod.ui.actions.FindReferencesInProjectAction;
import org.eclipse.dltk.mod.ui.actions.FindReferencesInWorkingSetAction;
import org.eclipse.dltk.mod.ui.actions.FindSatisfiersAction;
import org.eclipse.dltk.mod.ui.actions.FindSatisfiersInHierarchyAction;
import org.eclipse.dltk.mod.ui.actions.FindSatisfiersInProjectAction;
import org.eclipse.dltk.mod.ui.actions.FindSatisfiersInWorkingSetAction;
import org.eclipse.dltk.mod.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.mod.ui.actions.WorkingSetFindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class ReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_references;
    private IWorkbenchSite fSite;
    private ScriptEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindReferencesAction fFindReferencesAction;
    private FindReferencesAction fFindSatisfiersAction;
    private FindReferencesInProjectAction fFindReferencesInProjectAction;
    private FindReferencesInProjectAction fFindSatisfiersInProjectAction;
    private FindReferencesInHierarchyAction fFindReferencesInHierarchyAction;
    private FindReferencesInHierarchyAction fFindSatisfiersInHierarchyAction;
    private FindReferencesInWorkingSetAction fFindReferencesInWorkingSetAction;
    private FindReferencesInWorkingSetAction fFindSatisfiersInWorkingSetAction;
    private final IDLTKLanguageToolkit toolkit;

    public ReferencesSearchGroup(IWorkbenchSite site, IDLTKLanguageToolkit tk) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.toolkit = tk;
        this.fFindReferencesAction = new FindReferencesAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindSatisfiersAction = new FindSatisfiersAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindReferencesAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.references.in.workspace");
        this.fFindSatisfiersAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.satisfiers.in.workspace");
        this.fFindReferencesInProjectAction = new FindReferencesInProjectAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindReferencesInProjectAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.references.in.project");
        this.fFindSatisfiersInProjectAction = new FindSatisfiersInProjectAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindSatisfiersInProjectAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.satisfiers.in.project");
        this.fFindReferencesInHierarchyAction = new FindReferencesInHierarchyAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.references.in.hierarchy");
        this.fFindSatisfiersInHierarchyAction = new FindSatisfiersInHierarchyAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindSatisfiersInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.satisfiers.in.hierarchy");
        this.fFindReferencesInWorkingSetAction = new FindReferencesInWorkingSetAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.references.in.working.set");
        this.fFindSatisfiersInWorkingSetAction = new FindSatisfiersInWorkingSetAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindSatisfiersInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.satisfiers.in.working.set");
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fFindReferencesAction, provider, selection);
        this.registerAction(this.fFindSatisfiersAction, provider, selection);
        this.registerAction(this.fFindReferencesInProjectAction, provider, selection);
        this.registerAction(this.fFindSatisfiersInProjectAction, provider, selection);
        this.registerAction(this.fFindReferencesInHierarchyAction, provider, selection);
        this.registerAction(this.fFindSatisfiersInHierarchyAction, provider, selection);
        this.registerAction(this.fFindReferencesInWorkingSetAction, provider, selection);
        this.registerAction(this.fFindSatisfiersInWorkingSetAction, provider, selection);
    }

    public ReferencesSearchGroup(ScriptEditor editor, IDLTKLanguageToolkit tk) {
        Assert.isNotNull((Object)editor);
        this.toolkit = tk;
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindReferencesAction = new FindReferencesAction(editor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindReferencesAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.references.in.workspace");
        this.fEditor.setAction("SearchReferencesInWorkspace", (IAction)this.fFindReferencesAction);
        this.fFindSatisfiersAction = new FindSatisfiersAction(editor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindSatisfiersAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.satisfiers.in.workspace");
        this.fEditor.setAction("SearchSatisfiersInWorkspace", (IAction)this.fFindSatisfiersAction);
        this.fFindReferencesInProjectAction = new FindReferencesInProjectAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindReferencesInProjectAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.references.in.project");
        this.fEditor.setAction("SearchReferencesInProject", (IAction)this.fFindReferencesInProjectAction);
        this.fFindSatisfiersInProjectAction = new FindSatisfiersInProjectAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindSatisfiersInProjectAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.satisfiers.in.project");
        this.fEditor.setAction("SearchReferencesInProject", (IAction)this.fFindSatisfiersInProjectAction);
        this.fFindReferencesInHierarchyAction = new FindReferencesInHierarchyAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.references.in.hierarchy");
        this.fEditor.setAction("SearchReferencesInHierarchy", (IAction)this.fFindReferencesInHierarchyAction);
        this.fFindSatisfiersInHierarchyAction = new FindSatisfiersInHierarchyAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindSatisfiersInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.satisfiers.in.hierarchy");
        this.fEditor.setAction("SearchReferencesInHierarchy", (IAction)this.fFindSatisfiersInHierarchyAction);
        this.fFindReferencesInWorkingSetAction = new FindReferencesInWorkingSetAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.references.in.working.set");
        this.fEditor.setAction("SearchReferencesInWorkingSet", (IAction)this.fFindReferencesInWorkingSetAction);
        this.fFindSatisfiersInWorkingSetAction = new FindSatisfiersInWorkingSetAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        };
        this.fFindSatisfiersInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.satisfiers.in.working.set");
        this.fEditor.setAction("SearchReferencesInWorkingSet", (IAction)this.fFindSatisfiersInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    protected String getName() {
        return MENU_TEXT;
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
        WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindReferencesInWorkingSetAction(this.fEditor, workingSets){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        }, SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindReferencesInWorkingSetAction(this.fSite, workingSets){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return ReferencesSearchGroup.this.toolkit;
            }
        }, SearchUtil.toString(workingSets));
        action.update(this.getContext().getSelection());
        this.addAction((IAction)action, manager);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(this.getName(), "group.search");
        this.addAction((IAction)this.fFindReferencesAction, (IMenuManager)javaSearchMM);
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindReferencesAction, provider);
            this.disposeAction(this.fFindSatisfiersAction, provider);
            this.disposeAction(this.fFindReferencesInProjectAction, provider);
            this.disposeAction(this.fFindSatisfiersInProjectAction, provider);
            this.disposeAction(this.fFindReferencesInHierarchyAction, provider);
            this.disposeAction(this.fFindSatisfiersInHierarchyAction, provider);
            this.disposeAction(this.fFindReferencesInWorkingSetAction, provider);
            this.disposeAction(this.fFindSatisfiersInWorkingSetAction, provider);
        }
        this.fFindReferencesAction = null;
        this.fFindSatisfiersAction = null;
        this.fFindReferencesInProjectAction = null;
        this.fFindSatisfiersInProjectAction = null;
        this.fFindReferencesInHierarchyAction = null;
        this.fFindSatisfiersInHierarchyAction = null;
        this.fFindReferencesInWorkingSetAction = null;
        this.fFindSatisfiersInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.ReferencesInWorkspace", (IAction)this.fFindReferencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.SatisfiersInWorkspace", (IAction)this.fFindSatisfiersAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.ReferencesInProject", (IAction)this.fFindReferencesInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.SatisfiersInProject", (IAction)this.fFindSatisfiersInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.ReferencesInHierarchy", (IAction)this.fFindReferencesInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.SatisfiersInHierarchy", (IAction)this.fFindSatisfiersInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.ReferencesInWorkingSet", (IAction)this.fFindReferencesInWorkingSetAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.SatisfiersInWorkingSet", (IAction)this.fFindSatisfiersInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

