/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.actions.DeclarationsSearchGroup;
import org.eclipse.dltk.mod.ui.actions.ReferencesSearchGroup;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class SearchActionGroup
extends ActionGroup {
    private ScriptEditor fEditor;
    private ReferencesSearchGroup fReferencesGroup;
    private DeclarationsSearchGroup fDeclarationsGroup;

    public SearchActionGroup(IViewPart part, IDLTKLanguageToolkit toolkit) {
        this((IWorkbenchSite)part.getViewSite(), toolkit);
    }

    public SearchActionGroup(Page page, IDLTKLanguageToolkit toolkit) {
        this((IWorkbenchSite)page.getSite(), toolkit);
    }

    public SearchActionGroup(ScriptEditor editor) {
        this.fEditor = editor;
        this.fReferencesGroup = new ReferencesSearchGroup(this.fEditor, this.fEditor.getLanguageToolkit());
        this.fDeclarationsGroup = new DeclarationsSearchGroup(this.fEditor, this.fEditor.getLanguageToolkit());
    }

    private SearchActionGroup(IWorkbenchSite site, IDLTKLanguageToolkit toolkit) {
        this.fReferencesGroup = new ReferencesSearchGroup(site, toolkit);
        this.fDeclarationsGroup = new DeclarationsSearchGroup(site, toolkit);
    }

    public void setContext(ActionContext context) {
        this.fReferencesGroup.setContext(context);
        this.fDeclarationsGroup.setContext(context);
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.fReferencesGroup.fillActionBars(actionBar);
        this.fDeclarationsGroup.fillActionBars(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("Search.usereducemenu")) {
            this.fReferencesGroup.fillContextMenu(menu);
            this.fDeclarationsGroup.fillContextMenu(menu);
        } else {
            IMenuManager target = menu;
            MenuManager searchSubMenu = null;
            if (this.fEditor != null) {
                String groupName = SearchMessages.group_search;
                searchSubMenu = new MenuManager(groupName, "group.find");
                searchSubMenu.add((IContributionItem)new GroupMarker("group.find"));
                target = searchSubMenu;
            }
            this.fReferencesGroup.fillContextMenu(target);
            this.fDeclarationsGroup.fillContextMenu(target);
            if (searchSubMenu != null && searchSubMenu.getItems().length > 2) {
                menu.appendToGroup("group.find", (IContributionItem)searchSubMenu);
            }
        }
    }

    public void dispose() {
        this.fReferencesGroup.dispose();
        this.fDeclarationsGroup.dispose();
        super.dispose();
    }
}

