/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.browsing;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.ui.filters.NonScriptElementFilter;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.actions.SelectAllAction;
import org.eclipse.dltk.mod.ui.browsing.LogicalPackage;
import org.eclipse.dltk.mod.ui.browsing.ScriptBrowsingPart;
import org.eclipse.dltk.mod.ui.browsing.TopLevelTypeProblemsLabelDecorator;
import org.eclipse.dltk.mod.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.mod.ui.viewsupport.DecoratingModelLabelProvider;
import org.eclipse.dltk.mod.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class TypesView
extends ScriptBrowsingPart {
    private SelectAllAction fSelectAllAction;

    @Override
    protected ScriptUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(2815849278734379L, 1, DLTKUIPlugin.getDefault().getPreferenceStore());
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        StructuredViewer viewer = super.createViewer(parent);
        return viewer;
    }

    @Override
    public Object getAdapter(Class key) {
        return super.getAdapter(key);
    }

    @Override
    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)new NonScriptElementFilter());
    }

    @Override
    protected boolean isValidInput(Object element) {
        return element instanceof IScriptFolder;
    }

    @Override
    protected boolean isValidElement(Object element) {
        if (element instanceof ISourceModule) {
            return super.isValidElement(((ISourceModule)element).getParent());
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.getDeclaringType() == null && this.isValidElement(type.getSourceModule());
        }
        return false;
    }

    @Override
    protected IModelElement findElementToSelect(IModelElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    type = (IType)je;
                }
                return type;
            }
            case 5: {
                return this.getTypeForCU((ISourceModule)je);
            }
            case 10: {
                return this.findElementToSelect(je.getParent());
            }
        }
        if (je instanceof IMember) {
            return this.findElementToSelect((IModelElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    @Override
    protected String getHelpContextId() {
        return "";
    }

    @Override
    protected String getLinkToEditorKey() {
        return "org.eclipse.dltk.mod.ui.browsing.types.to.editor";
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction((TableViewer)this.getViewer());
    }

    @Override
    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object selectedElement = sel.getFirstElement();
            if (sel.size() == 1 && selectedElement instanceof LogicalPackage) {
                IScriptFolder[] fragments = ((LogicalPackage)((Object)selectedElement)).getScriptFolders();
                List<IScriptFolder> selectedElements = Arrays.asList(fragments);
                if (selectedElements.size() > 1) {
                    this.adjustInput(part, selectedElements);
                    this.fPreviousSelectedElement = selectedElements;
                    this.fPreviousSelectionProvider = part;
                } else if (selectedElements.size() == 1) {
                    super.selectionChanged(part, (ISelection)new StructuredSelection((Object)selectedElements.get(0)));
                } else {
                    Assert.isLegal((boolean)false);
                }
                return;
            }
        }
        super.selectionChanged(part, selection);
    }

    private void adjustInput(IWorkbenchPart part, List selectedElements) {
        Object currentInput = this.getViewer().getInput();
        if (!selectedElements.equals(currentInput)) {
            this.setInput(selectedElements);
        }
    }

    @Override
    protected DecoratingModelLabelProvider createDecoratingLabelProvider(ScriptUILabelProvider provider) {
        DecoratingModelLabelProvider decoratingLabelProvider = super.createDecoratingLabelProvider(provider);
        provider.addLabelDecorator(new TopLevelTypeProblemsLabelDecorator(null));
        return decoratingLabelProvider;
    }
}

