/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.templates;

import org.eclipse.dltk.mod.ui.templates.ScriptTemplateContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;

public class ScriptTemplateProposal
extends TemplateProposal {
    private boolean isRelevanceOverriden;
    private int relevanceOverride;

    public ScriptTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
    }

    public int getRelevance() {
        return this.isRelevanceOverriden ? this.relevanceOverride : super.getRelevance();
    }

    public void setRelevance(int value) {
        this.relevanceOverride = value;
        this.isRelevanceOverriden = true;
    }

    public String getAdditionalProposalInfo() {
        TemplateContext context = this.getContext();
        if (context instanceof ScriptTemplateContext) {
            ScriptTemplateContext scriptContext = (ScriptTemplateContext)context;
            try {
                this.getContext().setReadOnly(true);
                TemplateBuffer templateBuffer = scriptContext.evaluate(this.getTemplate());
                IDocument document = scriptContext.getDocument();
                String indenting = ScriptTemplateContext.calculateIndent(document, scriptContext.getStart());
                String delimeter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                String info = templateBuffer.getString();
                return info.replaceAll(String.valueOf(delimeter) + indenting, delimeter);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (TemplateException templateException) {}
        }
        return null;
    }

    public String getPattern() {
        return this.getTemplate().getPattern();
    }
}

