/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.text.completion;

import org.eclipse.dltk.mod.core.CompletionContext;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.mod.ui.text.completion.ContentAssistHistory;
import org.eclipse.dltk.mod.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.mod.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.mod.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public abstract class ScriptContentAssistInvocationContext
extends ContentAssistInvocationContext {
    private final IEditorPart fEditor;
    private ISourceModule fSourceModule = null;
    private boolean fSourceModuleComputed = false;
    private CompletionProposalLabelProvider fLabelProvider;
    private ScriptCompletionProposalCollector fCollector;
    private ContentAssistHistory.RHSHistory fRHSHistory;
    private IType fType;
    private String fLanguageNatureID;
    private boolean isContextInformationMode;

    public ScriptContentAssistInvocationContext(ITextViewer viewer, int offset, IEditorPart editor, String natureId) {
        super(viewer, offset);
        this.fEditor = editor;
        this.fLanguageNatureID = natureId;
    }

    public ScriptContentAssistInvocationContext(ISourceModule unit) {
        this.fSourceModule = unit;
        this.fSourceModuleComputed = true;
        this.fEditor = null;
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    public String getLanguageNatureID() {
        return this.fLanguageNatureID;
    }

    public ISourceModule getSourceModule() {
        if (!this.fSourceModuleComputed) {
            this.fSourceModuleComputed = true;
            if (this.fCollector != null) {
                this.fSourceModule = this.fCollector.getSourceModule();
            } else {
                ISourceModule je = EditorUtility.getEditorInputModelElement(this.fEditor, false);
                if (je instanceof ISourceModule) {
                    this.fSourceModule = je;
                }
            }
        }
        return this.fSourceModule;
    }

    public IScriptProject getProject() {
        ISourceModule unit = this.getSourceModule();
        return unit == null ? null : unit.getScriptProject();
    }

    public IScriptCompletionProposal[] getKeywordProposals() {
        if (this.fCollector != null) {
            return this.fCollector.getKeywordCompletionProposals();
        }
        return new IScriptCompletionProposal[0];
    }

    public void setCollector(ScriptCompletionProposalCollector collector) {
        this.fCollector = collector;
    }

    public CompletionContext getCoreContext() {
        if (this.fCollector != null) {
            return this.fCollector.getContext();
        }
        return null;
    }

    public float getHistoryRelevance(String qualifiedTypeName) {
        return this.getRHSHistory().getRank(qualifiedTypeName);
    }

    private ContentAssistHistory.RHSHistory getRHSHistory() {
        if (this.fRHSHistory == null) {
            CompletionContext context = this.getCoreContext();
            if (this.fRHSHistory == null) {
                this.fRHSHistory = DLTKUIPlugin.getDefault().getContentAssistHistory().getHistory(null);
            }
        }
        return this.fRHSHistory;
    }

    public IType getExpectedType() {
        return this.fType;
    }

    public CompletionProposalLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = this.fCollector != null ? this.fCollector.getLabelProvider() : this.createLabelProvider();
        }
        return this.fLabelProvider;
    }

    protected abstract CompletionProposalLabelProvider createLabelProvider();

    public void setContextInformationMode(boolean value) {
        this.isContextInformationMode = value;
    }

    public boolean isContextInformationMode() {
        return this.isContextInformationMode;
    }
}

