/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.text.folding;

import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementVisitor;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.SourceRefElement;
import org.eclipse.dltk.mod.internal.core.SourceType;
import org.eclipse.dltk.mod.ui.text.folding.IElementCommentResolver;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class DefaultElementCommentResolver
implements IElementCommentResolver {
    protected IModelElement getContainingElement(IModelElement el, int offset, int length) throws ModelException {
        PositionVisitor visitor = new PositionVisitor(offset, length);
        el.accept((IModelElementVisitor)visitor);
        return visitor.result;
    }

    @Override
    public IModelElement getElementByCommentPosition(ISourceModule content, int offset, int length) {
        try {
            return this.getElementByCommentPositionImpl(content, offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    protected IModelElement getElementByCommentPositionImpl(ISourceModule content, int offset, int length) throws BadLocationException, ModelException {
        Document d = new Document(content.getSource());
        if (!this.checkIfPositionIsComment(d, offset)) {
            return null;
        }
        IModelElement el = this.getContainingElement((IModelElement)content, offset, length);
        if (el != null && el.getElementType() == 9) {
            return el;
        }
        int sourceRangeEnd = this.getSourceRangeEnd(d, el);
        IModelElement res = this.searchForNonCommentElement(d, content, offset + length, sourceRangeEnd);
        if (res == null) {
            return el;
        }
        return res;
    }

    protected int getSourceRangeEnd(Document d, IModelElement el) throws ModelException {
        int sourceRangeEnd = d.getLength();
        if (el != null && el.getElementType() == 7) {
            SourceType t = (SourceType)el;
            sourceRangeEnd = t.getSourceRange().getOffset() + t.getSourceRange().getLength();
        }
        return sourceRangeEnd;
    }

    protected boolean checkIfPositionIsComment(Document d, int offset) throws BadLocationException {
        int line = d.getLineOfOffset(offset);
        int q = d.getLineOffset(line);
        while (q < d.getLength() && Character.isWhitespace(d.getChar(q)) && q <= offset) {
            ++q;
        }
        return d.getChar(q) == '#';
    }

    /*
     * Unable to fully structure code
     */
    protected IModelElement searchForNonCommentElement(Document d, ISourceModule content, int endOfCommentOffset, int lowerbound) throws BadLocationException, ModelException {
        res = null;
        off = endOfCommentOffset;
        line = d.getLineOfOffset(off);
        off = d.getLineOffset(line);
        ** GOTO lbl13
        {
            ++off;
            do {
                if (off < lowerbound - 1 && Character.isWhitespace(d.getChar(off))) continue block0;
                if (d.getChar(off) != '#') {
                    res = content.getElementAt(off);
                    break block0;
                }
                off = d.getLineOffset(++line);
lbl13:
                // 2 sources

            } while (off < lowerbound);
        }
        return res;
    }

    private static class PositionVisitor
    implements IModelElementVisitor {
        IModelElement result = null;
        private final int offset;
        private final int length;

        public PositionVisitor(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public boolean visit(IModelElement el) {
            if (el instanceof SourceRefElement) {
                ISourceRange range;
                SourceRefElement element = (SourceRefElement)el;
                try {
                    range = element.getSourceRange();
                }
                catch (ModelException modelException) {
                    return true;
                }
                if (this.offset >= range.getOffset() && this.offset + this.length <= range.getOffset() + range.getLength() && (element.getElementType() == 9 || element.getElementType() == 7)) {
                    this.result = element;
                }
            }
            return true;
        }
    }
}

