/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.validators.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.validators.internal.core.ValidatorsCore;

public abstract class AbstractExternalValidator {
    protected abstract String getMarkerType();

    public void clean(ISourceModule[] modules) {
        this.clean(this.toResources(modules));
    }

    public void clean(IResource[] resources) {
        String markerType = this.getMarkerType();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.clean(resource, markerType);
            ++i;
        }
    }

    protected void clean(IResource resource, String markerType) {
        try {
            resource.deleteMarkers(markerType, true, 2);
        }
        catch (CoreException e) {
            ValidatorsCore.log(e.getStatus());
        }
    }

    protected void clean(IResource resource) {
        this.clean(resource, this.getMarkerType());
    }

    protected IResource[] toResources(ISourceModule[] modules) {
        ArrayList<IResource> resources = new ArrayList<IResource>(modules.length);
        int i = 0;
        while (i < modules.length) {
            IResource resource = modules[i].getResource();
            if (resource != null) {
                resources.add(resource);
            }
            ++i;
        }
        IResource[] result = new IResource[resources.size()];
        resources.toArray(result);
        return result;
    }

    protected IMarker createMarker(IResource res, int line, int start, int end, String msg, int severity, int priority) throws CoreException {
        IMarker m = res.createMarker(this.getMarkerType());
        m.setAttribute("lineNumber", line);
        m.setAttribute("message", (Object)msg);
        m.setAttribute("severity", severity);
        m.setAttribute("priority", priority);
        m.setAttribute("charStart", start);
        m.setAttribute("charEnd", end);
        return m;
    }

    protected IMarker reportWarning(IResource res, int line, int start, int end, String msg) throws CoreException {
        return this.createMarker(res, line, start, end, msg, 1, 1);
    }

    protected IMarker reportError(IResource res, int line, int start, int end, String msg) throws CoreException {
        return this.createMarker(res, line, start, end, msg, 2, 1);
    }
}

