/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.mod.core.AbstractLanguageToolkit;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.environment.IFileHandle;

public class VjoLanguageToolkit
extends AbstractLanguageToolkit {
    private static final String LANGUAGE_NAME = "VJO (JavaScript)";
    private static VjoLanguageToolkit s_instance = new VjoLanguageToolkit();
    public static final String VJET_CONTENT_TYPE_ID = "org.eclipse.dltk.mod.vjoContentType";

    public static IDLTKLanguageToolkit getDefault() {
        return s_instance;
    }

    public String getLanguageContentType() {
        return VJET_CONTENT_TYPE_ID;
    }

    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    public String getNatureId() {
        return "org.eclipse.vjet.core.nature";
    }

    public boolean languageSupportZIPBuildpath() {
        return true;
    }

    public static boolean isVjetContentType(IFile file) {
        IContentType type1 = VjoLanguageToolkit.getVjetContentType();
        IContentType[] type = Platform.getContentTypeManager().findContentTypesFor(file.getName());
        boolean isKind = false;
        IContentType[] iContentTypeArray = type;
        int n = type.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType iContentType = iContentTypeArray[n2];
            if (iContentType.isKindOf(type1)) {
                isKind = true;
                break;
            }
            ++n2;
        }
        return type != null && isKind;
    }

    public static IContentType getVjetContentType() {
        return Platform.getContentTypeManager().getContentType(VJET_CONTENT_TYPE_ID);
    }

    public boolean canValidateContent(File file) {
        IContentType contentType = VjoLanguageToolkit.getVjetContentType();
        return contentType.isAssociatedWith(file.getName());
    }

    public boolean canValidateContent(IFileHandle file) {
        IContentType contentType = VjoLanguageToolkit.getVjetContentType();
        return contentType.isAssociatedWith(file.getName());
    }

    public boolean canValidateContent(IResource resource) {
        if (1 == resource.getType()) {
            return VjoLanguageToolkit.isVjetContentType((IFile)resource);
        }
        return false;
    }
}

