/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMatchFactory;
import org.eclipse.vjet.eclipse.core.ts.GenericVisitor;

public abstract class AbstractVjoOccurrenceVisitor
extends GenericVisitor {
    private Set<IJstNode> m_foundNodes;
    private ArrayList<VjoMatch> m_matches;
    private String m_matchName;
    private IJstNode m_matchNode;

    public AbstractVjoOccurrenceVisitor(IJstNode matchNode) {
        this.m_matchNode = matchNode;
        this.m_matches = new ArrayList();
        this.m_foundNodes = new HashSet<IJstNode>();
    }

    public List<VjoMatch> getMatches() {
        return this.m_matches;
    }

    protected void addMatch(IJstNode matchedNode) {
        if (this.m_foundNodes.contains(matchedNode)) {
            return;
        }
        this.m_foundNodes.add(matchedNode);
        JstSource source = matchedNode.getSource();
        if (source == null) {
            return;
        }
        VjoMatch match = VjoMatchFactory.createOccurrenceMatch(matchedNode, source.getStartOffSet(), source.getLength());
        this.m_matches.add(match);
    }

    protected IJstNode getMatchNode() {
        return this.m_matchNode;
    }

    protected boolean matchName(String name) {
        if (this.m_matchName != null) {
            return this.m_matchName.equals(name);
        }
        return false;
    }

    protected boolean matchNode(IJstNode node) {
        return this.m_matchNode.equals(node);
    }

    protected void setMatchName(String name) {
        this.m_matchName = name;
    }
}

