/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.ts.JstQueryExecutor;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;

final class SearchUtil {
    SearchUtil() {
    }

    public static IJstNode getSearchedJstNode(SearchQueryParameters parameters, TypeSpace<IJstType, IJstNode> typeSpace) {
        int startOffset;
        ISourceRange sourceRange;
        if (parameters == null || typeSpace == null) {
            return null;
        }
        if (!(parameters.getElement() instanceof IMember)) {
            return null;
        }
        IMember searchedElement = (IMember)parameters.getElement();
        if (!(searchedElement.getSourceModule() instanceof VjoSourceModule)) {
            return null;
        }
        JstQueryExecutor queryExecutor = new JstQueryExecutor(typeSpace);
        VjoSourceModule module = (VjoSourceModule)searchedElement.getSourceModule();
        SourceTypeName rootTypeName = module.getTypeName();
        IJstType rootType = queryExecutor.findType((TypeName)rootTypeName);
        if (rootType == null) {
            return null;
        }
        try {
            sourceRange = searchedElement.getSourceRange();
        }
        catch (ModelException e) {
            VjetPlugin.error(e.getMessage(), e);
            return null;
        }
        int endOffset = startOffset = sourceRange.getOffset();
        return JstUtil.getLeafNode((IJstType)rootType, (int)startOffset, (int)endOffset);
    }

    public static boolean isVjDollarProp(IJstProperty jstProperty) {
        if (jstProperty == null) {
            return false;
        }
        return "Vj$Type".equals(jstProperty.getOwnerType().getName());
    }

    public static IJstType lookupJstType(IJstType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JstProxyType) {
            return SearchUtil.lookupJstType(((JstProxyType)type).getType());
        }
        return type;
    }
}

