/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class TypeSearcher {
    private static TypeSearcher s_searcher = new TypeSearcher();
    private TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();

    public List<IJstType> search(String pattern) {
        ArrayList<IJstType> list = new ArrayList<IJstType>();
        Collection list2 = this.mgr.getAllTypes();
        for (IJstType jstType : list2) {
            if (!this.match(pattern, jstType)) continue;
            list.add(jstType);
        }
        return list;
    }

    private boolean match(String pattern, IJstType type) {
        String name = type.getName();
        String simpleName = type.getSimpleName();
        boolean isFullQualifiedNameMatch = false;
        if (name != null) {
            isFullQualifiedNameMatch = Pattern.matches(TypeSearcher.wildcardToRegex(pattern.toLowerCase()), name.toLowerCase());
        }
        boolean isSimpleNameMatch = false;
        if (simpleName != null) {
            isSimpleNameMatch = Pattern.matches(TypeSearcher.wildcardToRegex(pattern.toLowerCase()), simpleName.toLowerCase());
        }
        return isFullQualifiedNameMatch || isSimpleNameMatch;
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int i = 0;
        int is = wildcard.length();
        while (i < is) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    break;
                }
                case '?': {
                    s.append(".");
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    break;
                }
                default: {
                    s.append(c);
                }
            }
            ++i;
        }
        if (s.indexOf("*") < 0) {
            s.append(".*");
        }
        s.append('$');
        return s.toString();
    }

    private TypeSearcher() {
    }

    public static TypeSearcher getInstance() {
        return s_searcher;
    }
}

