/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.internal.core.NativeVjoSourceModule;
import org.eclipse.dltk.mod.internal.core.search.matching.FieldPattern;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.jst.traversal.JstDepthFirstTraversal;
import org.eclipse.vjet.dsf.ts.property.PropertyName;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.search.AbstractVjoElementSearcher;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoFieldOccurrenceVisitor;
import org.eclipse.vjet.eclipse.core.search.VjoFieldReferenceVistor;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMatchFactory;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

class VjoFieldSearcher
extends AbstractVjoElementSearcher {
    public static final int TYPE_PROP = 2;
    public static final int LOCAL_VAR = 1;
    public static final int METHOD_ARG = 0;

    VjoFieldSearcher() {
    }

    @Override
    public Class<? extends SearchPattern> getSearchPatternClass() {
        return FieldPattern.class;
    }

    @Override
    protected void searchDeclarations(SearchQueryParameters params, List<VjoMatch> result) {
        IField element = (IField)params.getElement();
        IVjoSourceModule module = (IVjoSourceModule)element.getSourceModule();
        IField field = this.findFieldDeclaration(element, module);
        TypeName typeName = module.getTypeName();
        IType type = CodeassistUtils.findResourceType(module, typeName.typeName());
        if (this.isInScope(type) && field != null) {
            try {
                ISourceRange nameRange = field.getNameRange();
                VjoMatch match = VjoMatchFactory.createMethodMatch(type, nameRange.getOffset(), nameRange.getLength());
                result.add(match);
                try {
                    match.setIsPublic(Flags.isPublic((int)field.getFlags()));
                    match.setIsStatic(Flags.isStatic((int)field.getFlags()));
                }
                catch (ModelException modelException) {}
            }
            catch (ModelException e) {
                VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.vjet.eclipse.core", 4, "Wrong name range", (Throwable)e));
            }
        }
    }

    private IField findFieldDeclaration(IField element, IVjoSourceModule module) {
        IModelElement parent;
        IField field;
        block5: {
            field = null;
            try {
                int offset = element.getNameRange().getOffset();
                parent = module.getElementAt(offset);
                if (parent != null) break block5;
                return null;
            }
            catch (ModelException modelException) {}
        }
        if (parent instanceof IField) {
            field = (IField)parent;
        } else {
            String name = element.getElementName();
            field = (IField)CodeassistUtils.findChild(name, parent);
        }
        return field;
    }

    @Override
    protected void searchReferences(SearchQueryParameters params, List<VjoMatch> result) {
        IField field = (IField)params.getElement();
        if (this.isLocal(field)) {
            IJstMethod jstMethod = this.getJstMethod(field);
            this.findRefs(field, (IJstNode)jstMethod, result);
        } else if (field.getSourceModule() instanceof NativeVjoSourceModule) {
            this.processNativeTypeField(field, result);
        } else {
            this.processSourceTypeField(field, result);
        }
    }

    private void processSourceTypeField(IField field, List<VjoMatch> result) {
        IJstProperty jstProperty = this.getJstProperty(field);
        if (jstProperty == null) {
            return;
        }
        String grouName = jstProperty.getOwnerType().getPackage().getGroupName();
        String typeName = jstProperty.getOwnerType().getName();
        PropertyName propertyName = new PropertyName(new TypeName(grouName, typeName), field.getElementName());
        List list = this.mgr.getPropertyDependents(propertyName);
        for (IJstNode jstNode : list) {
            this.findRefs(field, jstNode, result);
        }
    }

    private void processNativeTypeField(IField field, List<VjoMatch> result) {
        NativeVjoSourceModule nativeVjoSourceModule = (NativeVjoSourceModule)field.getSourceModule();
        String groupName = nativeVjoSourceModule.getTypeName().groupName();
        String typeName = nativeVjoSourceModule.getTypeName().typeName();
        PropertyName propertyName = new PropertyName(new TypeName(groupName, typeName), field.getElementName());
        List list = this.mgr.getPropertyDependents(propertyName);
        for (IJstNode jstNode : list) {
            this.findRefs(field, jstNode, result);
        }
    }

    private void findRefs(IField field, IJstNode searchNode, List<VjoMatch> result) {
        if (searchNode == null) {
            return;
        }
        VjoFieldReferenceVistor fieldReferenceVistor = new VjoFieldReferenceVistor(field, searchNode, result);
        JstDepthFirstTraversal.accept((IJstNode)searchNode, (IJstVisitor)fieldReferenceVistor);
    }

    private boolean isLocal(IField field) {
        return field.getParent().getElementType() == 9;
    }

    private IJstMethod getJstMethod(IField field) {
        IVjoSourceModule module = (IVjoSourceModule)field.getSourceModule();
        TypeName jstTypeName = module.getTypeName();
        IJstType jstType = TypeSpaceMgr.findType((String)jstTypeName.groupName(), (String)jstTypeName.typeName());
        IType type = (IType)field.getParent().getParent();
        String dltkTypeName = type.getFullyQualifiedName(".");
        return this.getJstMethod(jstType, dltkTypeName, field.getParent().getElementName());
    }

    private IJstMethod getJstMethod(IJstType type, String typeName, String methodName) {
        if (type.getAlias().equals(typeName)) {
            IJstMethod jstMethod = type.getMethod(methodName);
            if (jstMethod == null && "constructs".equals(methodName)) {
                jstMethod = type.getConstructor();
            }
            return jstMethod;
        }
        for (IJstType innerType : type.getEmbededTypes()) {
            IJstMethod jstMethod = this.getJstMethod(innerType, typeName, methodName);
            if (jstMethod == null) continue;
            return jstMethod;
        }
        return null;
    }

    private IJstProperty getJstProperty(IField field) {
        IVjoSourceModule module = (IVjoSourceModule)field.getSourceModule();
        TypeName jstTypeName = module.getTypeName();
        IJstType jstType = TypeSpaceMgr.findType((String)jstTypeName.groupName(), (String)jstTypeName.typeName());
        if (!(field.getParent() instanceof IType) && field instanceof IField) {
            field = (IField)field.getParent();
        }
        String dltkTypeName = ((IType)field.getParent()).getFullyQualifiedName(".");
        return this.getJstProperty(jstType, dltkTypeName, field.getElementName());
    }

    private IJstProperty getJstProperty(IJstType type, String typeName, String propertyName) {
        if (type.getAlias().equals(typeName)) {
            IJstProperty jstProperty = type.getProperty(propertyName);
            IJstGlobalVar globalVar = type.getGlobalVar(propertyName);
            if (jstProperty == null && globalVar != null) {
                return globalVar.getProperty();
            }
            return jstProperty;
        }
        for (IJstType innerType : type.getEmbededTypes()) {
            IJstProperty jstProperty = this.getJstProperty(innerType, typeName, propertyName);
            if (jstProperty == null) continue;
            return jstProperty;
        }
        return null;
    }

    @Override
    public List<VjoMatch> findOccurrence(IJstNode jstNode, IJstNode scope) {
        int fieldType = -1;
        if (jstNode instanceof JstArg) {
            fieldType = 0;
        } else if (jstNode instanceof JstVars) {
            fieldType = 1;
        } else if (jstNode instanceof IJstProperty) {
            fieldType = 2;
        } else {
            VjetPlugin.error("Unhandled field node type in occurrence marking:" + jstNode.getClass().getName());
            return Collections.emptyList();
        }
        IJstNode searchedTree = scope;
        if (this.isLocal(fieldType)) {
            searchedTree = CodeassistUtils.findDeclaringMethod(jstNode);
        }
        if (searchedTree == null) {
            return Collections.emptyList();
        }
        return this.findOccurrence(fieldType, jstNode, searchedTree);
    }

    private boolean isLocal(int fieldType) {
        return 2 != fieldType;
    }

    private List<VjoMatch> findOccurrence(int fieldType, IJstNode matchNode, IJstNode jstTree) {
        VjoFieldOccurrenceVisitor visitor = new VjoFieldOccurrenceVisitor(fieldType, matchNode);
        jstTree.accept((IJstNodeVisitor)visitor);
        return visitor.getMatches();
    }

    private class LocalVarRefsRequestor {
        private List<IJstNode> refs = new LinkedList<IJstNode>();
        private String name = null;

        public void accept(IJstNode node) {
            List children;
            if (node == null) {
                return;
            }
            if (node instanceof JstIdentifier) {
                JstIdentifier identifier = (JstIdentifier)node;
                if (identifier.getName().equals(this.name)) {
                    this.refs.add((IJstNode)identifier);
                }
            } else {
                if (node instanceof JstVar) {
                    return;
                }
                if (node instanceof JstMethod) {
                    List args = ((JstMethod)node).getArgs();
                    for (JstArg jstArg : args) {
                        if (!this.name.equals(jstArg.getName())) continue;
                        this.refs.add((IJstNode)jstArg);
                    }
                }
            }
            if ((children = node.getChildren()) != null && children.size() > 0) {
                for (IJstNode jstNode : children) {
                    if (jstNode instanceof FieldAccessExpr) continue;
                    this.accept(jstNode);
                }
            }
        }

        public LocalVarRefsRequestor(String name) {
            this.name = name;
        }

        public List<IJstNode> getRefs() {
            return this.refs;
        }

        public String getName() {
            return this.name;
        }
    }
}

