/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.formatter;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.formatter.JSFormatterFactory;

public class CodeFormatterUtil {
    public static String createIndentString(int indentationUnits, IScriptProject project) {
        Map options = project != null ? project.getOptions(true) : VjetPlugin.getOptions();
        return JSFormatterFactory.createCodeFormatter(options).createIndentationString(indentationUnits);
    }

    public static int getTabWidth(IScriptProject project) {
        String key = "space".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.vjet.eclipse.core.formatter.tabulation.char")) ? "org.eclipse.vjet.eclipse.core.formatter.indentation.size" : "org.eclipse.vjet.eclipse.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    public static int getIndentWidth(IScriptProject project) {
        String key = "mixed".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.vjet.eclipse.core.formatter.tabulation.char")) ? "org.eclipse.vjet.eclipse.core.formatter.indentation.size" : "org.eclipse.vjet.eclipse.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    private static String getCoreOption(IScriptProject project, String key) {
        return project.getOption(key, true);
    }

    private static int getCoreOption(IScriptProject project, String key, int def) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(project, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static String format(int kind, String string, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        return CodeFormatterUtil.format(kind, string, 0, string.length(), indentationLevel, positions, lineSeparator, options);
    }

    public static String format(int kind, String string, int offset, int length, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        TextEdit edit = CodeFormatterUtil.format2(kind, string, offset, length, indentationLevel, lineSeparator, options);
        if (edit == null) {
            return string.substring(offset, offset + length);
        }
        String formatted = CodeFormatterUtil.getOldAPICompatibleResult(string, edit, indentationLevel, positions, lineSeparator, options);
        return formatted.substring(offset, formatted.length() - (string.length() - (offset + length)));
    }

    public static String format(ASTNode node, String string, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        TextEdit edit = CodeFormatterUtil.format2(node, string, indentationLevel, lineSeparator, options);
        if (edit == null) {
            return string;
        }
        return CodeFormatterUtil.getOldAPICompatibleResult(string, edit, indentationLevel, positions, lineSeparator, options);
    }

    private static String getOldAPICompatibleResult(String string, TextEdit edit, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        Position[] p = null;
        if (positions != null) {
            p = new Position[positions.length];
            int i = 0;
            while (i < positions.length) {
                p[i] = new Position(positions[i], 0);
                ++i;
            }
        }
        String res = CodeFormatterUtil.evaluateFormatterEdit(string, edit, p);
        if (positions != null) {
            int i = 0;
            while (i < positions.length) {
                Position curr = p[i];
                positions[i] = curr.getOffset();
                ++i;
            }
        }
        return res;
    }

    public static String evaluateFormatterEdit(String string, TextEdit edit, Position[] positions) {
        try {
            Document doc = CodeFormatterUtil.createDocument(string, positions);
            edit.apply((IDocument)doc, 0);
            if (positions != null) {
                int i = 0;
                while (i < positions.length) {
                    Assert.isTrue((!positions[i].isDeleted ? 1 : 0) != 0, (String)"Position got deleted");
                    ++i;
                }
            }
            return doc.get();
        }
        catch (BadLocationException e) {
            VjetPlugin.error("bug in the formatter", e);
            Assert.isTrue((boolean)false, (String)("Formatter created edits with wrong positions: " + e.getMessage()));
            return null;
        }
    }

    public static TextEdit format2(int kind, String string, int offset, int length, int indentationLevel, String lineSeparator, Map options) {
        if (offset < 0 || length < 0 || offset + length > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + string.length());
        }
        return JSFormatterFactory.createCodeFormatter(options).format(kind, string, offset, length, indentationLevel, lineSeparator);
    }

    public static TextEdit format2(int kind, String string, int indentationLevel, String lineSeparator, Map options) {
        return CodeFormatterUtil.format2(kind, string, 0, string.length(), indentationLevel, lineSeparator, options);
    }

    public static TextEdit reformat(int kind, String string, int offset, int length, int indentationLevel, String lineSeparator, Map options) {
        if (offset < 0 || length < 0 || offset + length > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + string.length());
        }
        return JSFormatterFactory.createCodeFormatter(options, JSFormatterFactory.M_FORMAT_EXISTING).format(kind, string, offset, length, indentationLevel, lineSeparator);
    }

    public static TextEdit reformat(int kind, String string, int indentationLevel, String lineSeparator, Map options) {
        return CodeFormatterUtil.reformat(kind, string, 0, string.length(), indentationLevel, lineSeparator, options);
    }

    public static TextEdit format2(ASTNode node, String str, int indentationLevel, String lineSeparator, Map options) {
        int code;
        String prefix = "";
        String suffix = "";
        if (node instanceof Statement) {
            code = 2;
            if (node.getASTType() == 19) {
                prefix = "switch(1) {";
                suffix = "}";
                code = 2;
            }
        } else if (node.getASTType() == 33 && node.getASTType() != 66) {
            code = 1;
        } else if (node.getASTType() == 16) {
            code = 4;
        } else {
            switch (node.getASTType()) {
                default: 
            }
            return null;
        }
        String concatStr = String.valueOf(prefix) + str + suffix;
        TextEdit edit = JSFormatterFactory.createCodeFormatter(options).format(code, concatStr, prefix.length(), str.length(), indentationLevel, lineSeparator);
        if (prefix.length() > 0) {
            edit = CodeFormatterUtil.shifEdit(edit, prefix.length());
        }
        return edit;
    }

    private static TextEdit shifEdit(TextEdit oldEdit, int diff) {
        MultiTextEdit newEdit;
        ReplaceEdit edit;
        if (oldEdit instanceof ReplaceEdit) {
            edit = (ReplaceEdit)oldEdit;
            newEdit = new ReplaceEdit(edit.getOffset() - diff, edit.getLength(), edit.getText());
        } else if (oldEdit instanceof InsertEdit) {
            edit = (InsertEdit)oldEdit;
            newEdit = new InsertEdit(edit.getOffset() - diff, edit.getText());
        } else if (oldEdit instanceof DeleteEdit) {
            edit = (DeleteEdit)oldEdit;
            newEdit = new DeleteEdit(edit.getOffset() - diff, edit.getLength());
        } else if (oldEdit instanceof MultiTextEdit) {
            newEdit = new MultiTextEdit();
        } else {
            return null;
        }
        TextEdit[] children = oldEdit.getChildren();
        int i = 0;
        while (i < children.length) {
            TextEdit shifted = CodeFormatterUtil.shifEdit(children[i], diff);
            if (shifted != null) {
                newEdit.addChild(shifted);
            }
            ++i;
        }
        return newEdit;
    }

    private static Document createDocument(String string, Position[] positions) throws IllegalArgumentException {
        Document doc;
        block5: {
            doc = new Document(string);
            try {
                if (positions == null) break block5;
                doc.addPositionCategory("myCategory");
                doc.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength) {
                            this.fPosition.offset = this.fOffset + this.fLength;
                            return false;
                        }
                        return true;
                    }
                });
                int i = 0;
                while (i < positions.length) {
                    try {
                        doc.addPosition("myCategory", positions[i]);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positions[i].offset + ", length: " + positions[i].length + ", string size: " + string.length());
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        return doc;
    }
}

