/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.codeassist.select.translator;

import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.SynthOlType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.internal.codeassist.select.JstNodeDLTKElementResolver;
import org.eclipse.vjet.eclipse.internal.codeassist.select.translator.DefaultNodeTranslator;

public class JstIdentifierTranslator
extends DefaultNodeTranslator {
    @Override
    public IJstNode lookupBinding(IJstNode jstNode) {
        JstIdentifier identifier = (JstIdentifier)jstNode;
        if (identifier.getParentNode() instanceof NV) {
            NV realParent = (NV)identifier.getParentNode();
            String fieldName = realParent.getName();
            ObjLiteral enclosingObjLiteral = (ObjLiteral)realParent.getParentNode();
            IJstType olExprType = enclosingObjLiteral.getResultType();
            if (olExprType != null && olExprType instanceof SynthOlType) {
                SynthOlType enclosingObjLiteralType = (SynthOlType)olExprType;
                List olResolvedTypes = enclosingObjLiteralType.getResolvedOTypes();
                if (olResolvedTypes == null) {
                    return null;
                }
                for (IJstType iJstType : olResolvedTypes) {
                    IJstProperty prop = iJstType.getProperty(fieldName);
                    if (prop == null) continue;
                    return prop;
                }
            }
        }
        if (identifier.getJstBinding() == null) {
            return null;
        }
        if (this.isKeyWord(identifier)) {
            return null;
        }
        IJstNode binding = identifier.getJstBinding();
        if ((binding == null || binding instanceof IJstType) && CodeassistUtils.isLocalVarDeclaration(identifier)) {
            binding = identifier.getParentNode().getParentNode();
        }
        if (binding == null || binding == identifier) {
            return null;
        }
        return JstNodeDLTKElementResolver.lookupBinding(binding);
    }

    private boolean isKeyWord(JstIdentifier identifier) {
        if ("this".equals(identifier.getName())) {
            return true;
        }
        return "vj$".equals(identifier.getName());
    }
}

