/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.ast.references.SimpleReference;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.ICallProcessor;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.DLTKSearchParticipant;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoSearchEngine;

public class VjoCallProcessor
implements ICallProcessor {
    public static final int GENERICS_AGNOSTIC_MATCH_RULE = 24;

    public Map process(IModelElement parent, IModelElement element, IDLTKSearchScope scope, IProgressMonitor monitor) {
        HashMap elements = new HashMap();
        VjoSearchRequestor requestor = new VjoSearchRequestor(elements, parent);
        SearchPattern pattern = SearchPattern.createPattern((IModelElement)element, (int)1, (int)24, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        try {
            VjoSearchEngine engine = new VjoSearchEngine();
            SearchQueryParameters parameters = new SearchQueryParameters();
            parameters.setElement(element);
            parameters.setElementSpecification(true);
            parameters.setPattern(pattern);
            parameters.setScope(scope);
            parameters.setLimitTo(1);
            List<VjoMatch> result = engine.search(parameters);
            for (VjoMatch vjoMatch : result) {
                requestor.acceptSearchMatch(vjoMatch);
            }
        }
        catch (Exception e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return elements;
    }

    public DLTKSearchParticipant getSearchParticipant(IModelElement element) {
        DLTKSearchParticipant par;
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
        if (toolkit != null && (par = DLTKLanguageManager.createSearchParticipant((String)toolkit.getNatureId())) != null) {
            return par;
        }
        return new DLTKSearchParticipant();
    }

    private final class VjoSearchRequestor {
        private final Map elements;
        private final IModelElement parent;

        private VjoSearchRequestor(Map elements, IModelElement parent) {
            this.elements = elements;
            this.parent = parent;
        }

        public void acceptSearchMatch(VjoMatch match) {
            if (match.getAccuracy() != 0) {
                return;
            }
            if (this.isModelElement(match)) {
                IModelElement member = (IModelElement)match.getElement();
                ISourceModule module = (ISourceModule)member.getAncestor(5);
                try {
                    this.createElement(match, module);
                }
                catch (ModelException e) {
                    DLTKCore.error((String)e.toString(), (Throwable)e);
                }
            }
        }

        private boolean isModelElement(VjoMatch match) {
            return match.getElement() != null && match.getElement() instanceof IModelElement;
        }

        private void createElement(VjoMatch match, ISourceModule module) throws ModelException {
            SimpleReference ref = new SimpleReference(match.getOffset(), match.getOffset() + match.getLength(), "");
            IType[] types = module.getAllTypes();
            if (types.length > 0) {
                int offset = match.getOffset();
                if (offset != -1) {
                    IMethod parentMethod = this.getMethod(types, offset);
                    this.elements.put(ref, parentMethod == null ? types[0] : parentMethod);
                } else {
                    IJstNode originalNode = match.getJstNode();
                    Assert.isNotNull((Object)originalNode);
                    IJstNode parent = originalNode.getParentNode();
                    while (parent != null) {
                        if (parent instanceof JstMethod) break;
                        parent = originalNode.getParentNode();
                    }
                    if (parent != null && parent instanceof JstMethod) {
                        IMethod[] dltkMethod;
                        IMethod[] iMethodArray = dltkMethod = CodeassistUtils.getMethod(types[0], (IJstMethod)parent);
                        int n = dltkMethod.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod m = iMethodArray[n2];
                            this.elements.put(ref, m == null ? types[0] : m);
                            ++n2;
                        }
                    }
                }
            }
        }

        private IMethod getMethod(IType[] types, int offset) throws ModelException {
            IMethod[] methods;
            IMethod parentMethod = null;
            IMethod[] iMethodArray = methods = types[0].getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                int start = method.getSourceRange().getOffset();
                int finish = method.getSourceRange().getLength() + start;
                if (start <= offset && finish >= offset) {
                    parentMethod = method;
                }
                ++n2;
            }
            return parentMethod;
        }
    }
}

