/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.search;

import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.mod.codeassist.ISelectionEngine;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IJSSourceModule;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoSearchOccurrenceEngine;
import org.eclipse.vjet.eclipse.internal.codeassist.select.VjoSelectionEngine;

public class VjoFindOccurencesEngine {
    public List<VjoMatch> findOccurences(IJSSourceModule module, IRegion region) throws ModelException {
        if (!(module instanceof VjoSourceModule)) {
            return Collections.emptyList();
        }
        VjoSourceModule vjoSourceModule = (VjoSourceModule)module;
        int offset = region.getOffset();
        offset = CodeassistUtils.findWordOffset((char[])module.getSourceAsCharArray(), (int)offset);
        region = VjoFindOccurencesEngine.findWord(module.getSource(), offset);
        IDLTKLanguageToolkit toolKit = DLTKLanguageManager.getLanguageToolkit((IModelElement)vjoSourceModule);
        ISelectionEngine selectionEngine = DLTKLanguageManager.getSelectionEngine((String)toolKit.getNatureId());
        if (!(selectionEngine instanceof VjoSelectionEngine)) {
            return Collections.emptyList();
        }
        VjoSelectionEngine vjoSelectionEngine = (VjoSelectionEngine)selectionEngine;
        IJstNode jstNode = vjoSelectionEngine.convertSelection2JstNode((ISourceModule)vjoSourceModule, region.getOffset(), region.getLength());
        IJstType scopeTree = CodeassistUtils.getJstType((IVjoSourceModule)vjoSourceModule);
        return VjoSearchOccurrenceEngine.findOccurrence((IJstNode)jstNode, (IJstNode)scopeTree);
    }

    public static IRegion findWord(String source, int offset) {
        char c;
        int start = -2;
        int end = -1;
        int pos = offset;
        while (pos >= 0) {
            c = source.charAt(pos);
            if (!Character.isJavaIdentifierPart(c)) break;
            --pos;
        }
        start = pos;
        pos = offset;
        int length = source.length();
        while (pos < length) {
            c = source.charAt(pos);
            if (!Character.isJavaIdentifierPart(c)) break;
            ++pos;
        }
        end = pos;
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

