/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class VjoDocAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private final String fPartitioning;

    public VjoDocAutoIndentStrategy(String partitioning) {
        this.fPartitioning = partitioning;
    }

    private void indentAfterNewLine(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            Assert.isTrue((firstNonWS >= lineOffset ? 1 : 0) != 0, (String)"indentation must not be negative");
            StringBuffer buf = new StringBuffer(c.text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            if (firstNonWS < offset && d.getChar(firstNonWS) == '/') {
                buf.append(" * ");
                if (this.isPreferenceTrue("closeComments") && this.isNewComment(d, offset)) {
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + buf.length();
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                    String endTag = String.valueOf(lineDelimiter) + indentation + " */";
                    buf.append(endTag);
                }
            }
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isPreferenceTrue(String preference) {
        return VjetUIPlugin.getDefault().getPreferenceStore().getBoolean(preference);
    }

    private IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '*') {
            ++indentEnd;
            while (indentEnd < lineEnd && document.getChar(indentEnd) == ' ') {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private void indentAfterCommentEnd(IDocument d, DocumentCommand c) {
        if (c.offset < 2 || d.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(d.get(c.offset - 2, 2))) {
                ++c.length;
                --c.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isNewComment(IDocument document, int commandOffset) {
        ITypedRegion partition;
        block7: {
            int partitionEnd;
            block6: {
                int lineIndex;
                block5: {
                    try {
                        lineIndex = document.getLineOfOffset(commandOffset) + 1;
                        if (lineIndex < document.getNumberOfLines()) break block5;
                        return true;
                    }
                    catch (BadLocationException badLocationException) {
                        return false;
                    }
                }
                IRegion line = document.getLineInformation(lineIndex);
                partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)commandOffset, (boolean)false);
                partitionEnd = partition.getOffset() + partition.getLength();
                if (line.getOffset() < partitionEnd) break block6;
                return false;
            }
            if (document.getLength() != partitionEnd) break block7;
            return true;
        }
        String comment = document.get(partition.getOffset(), partition.getLength());
        return comment.indexOf("/*", 2) != -1;
    }

    private boolean isSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = DLTKUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.isSmartMode()) {
            return;
        }
        if (command.text != null) {
            String[] lineDelimiters;
            int index;
            if (command.length == 0 && (index = TextUtilities.endsWith((String[])(lineDelimiters = document.getLegalLineDelimiters()), (String)command.text)) > -1) {
                if (lineDelimiters[index].equals(command.text)) {
                    this.indentAfterNewLine(document, command);
                }
                return;
            }
            if (command.text.equals("/")) {
                this.indentAfterCommentEnd(document, command);
                return;
            }
        }
    }
}

