/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.doc;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceReference;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.infoviews.AbstractDocumentationView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.internal.codeassist.select.VjoSelectionEngine;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.VjoProposalAditionalInfoGenerator;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.eclipse.ui.VjetUIUtils;

public class JsdocView
extends AbstractDocumentationView {
    private ISelection m_selection;

    protected String getNature() {
        return "org.eclipse.vjet.core.nature";
    }

    protected IPreferenceStore getPreferenceStore() {
        return VjetUIPlugin.getDefault().getPreferenceStore();
    }

    protected void setInput(final Object input) {
        new UIJob(this.getViewSite().getShell().getDisplay(), "Jsdoc Update Job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Control control;
                VjoEditor vjoEditor = VjetUIPlugin.getVjoEditor();
                if (vjoEditor == null) {
                    return Status.CANCEL_STATUS;
                }
                Object inputSrc = JsdocView.this.getInput();
                if (!(inputSrc instanceof IModelElement)) {
                    return Status.CANCEL_STATUS;
                }
                IModelElement selectedElement = (IModelElement)inputSrc;
                if (!(vjoEditor.getInputModelElement() instanceof IVjoSourceModule)) {
                    return Status.CANCEL_STATUS;
                }
                ISourceModule sm = (ISourceModule)vjoEditor.getInputModelElement();
                int offset = this.getOffset(selectedElement);
                if (offset == -1) {
                    return Status.CANCEL_STATUS;
                }
                VjoSelectionEngine selectionEngine = VjetUIUtils.getSelectionEngine();
                IJstNode selectedJstNode = selectionEngine.convertSelection2JstNode((org.eclipse.dltk.mod.compiler.env.ISourceModule)sm, offset, offset);
                String javadocHtml = VjoProposalAditionalInfoGenerator.getAdditionalPropesalInfo(selectedJstNode);
                if (javadocHtml == null || javadocHtml.length() == 0) {
                    javadocHtml = input.toString();
                }
                if ((control = JsdocView.this.getControl()) instanceof Browser) {
                    ((Browser)control).setText(javadocHtml);
                }
                return Status.OK_STATUS;
            }

            private int getOffset(IModelElement selectedElement) {
                int offset = -1;
                if (selectedElement instanceof ISourceReference) {
                    try {
                        offset = ((ISourceReference)selectedElement).getSourceRange().getOffset();
                    }
                    catch (ModelException e) {
                        VjetUIPlugin.log((Exception)((Object)e));
                    }
                }
                if (offset == -1 && JsdocView.this.m_selection instanceof ITextSelection) {
                    offset = ((ITextSelection)JsdocView.this.m_selection).getOffset();
                }
                return offset;
            }
        }.schedule();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        this.m_selection = selectionProvider != null ? selectionProvider.getSelection() : selection;
        super.selectionChanged(part, selection);
    }

    public Control getControl() {
        return super.getControl();
    }
}

