/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.util.DapDebugConsole;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.JavaScriptException;
import org.mozilla.mod.javascript.Scriptable;

public class ScriptExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeScript(String script, AWindow window) throws JavaScriptException {
        Object object = window.getJsExcutionLock();
        synchronized (object) {
            return ScriptExecutor.executeScript(script, window.getScope(), window.getContext(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeScript(String script, String srcId, AWindow window) throws JavaScriptException {
        Object object = window.getJsExcutionLock();
        synchronized (object) {
            return ScriptExecutor.executeScript(script, window.getScope(), window.getContext(), srcId);
        }
    }

    public static Object executeScript(String script, Scriptable scope, Context context) throws JavaScriptException {
        return ScriptExecutor.executeScript(script, scope, context, null);
    }

    public static Object executeScript(String script, Scriptable scope, Context context, String srcId) throws JavaScriptException {
        DapDebugConsole.enable(context, scope);
        String s = script.trim();
        Object ret = null;
        if (ActiveJsExecutionControlCtx.ctx().needDebug()) {
            Map<String, String> fragments = ScriptExecutor.getSourceFragments(s, srcId);
            for (Map.Entry<String, String> entry : fragments.entrySet()) {
                ret = context.evaluateString(scope, entry.getValue(), entry.getKey(), 1, null);
            }
        } else {
            String id = srcId == null ? ScriptExecutor.createKey(s) : srcId;
            ret = context.evaluateString(scope, s, id, 1, null);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, String> getSourceFragments(String data, String srcId) {
        block3: {
            fragments = new LinkedHashMap<String, String>();
            currentIndex = 0;
            tokenIndex = data.indexOf("//ACTIVE_JS_SRC:");
            if (tokenIndex != -1) ** GOTO lbl16
            id = srcId == null ? ScriptExecutor.createKey(data) : srcId;
            fragments.put(id, data);
            break block3;
lbl-1000:
            // 1 sources

            {
                if (tokenIndex > currentIndex && (fragment = data.substring(currentIndex, tokenIndex).trim()).length() > 0) {
                    fragments.put(ScriptExecutor.createKey(fragment), fragment);
                }
                currentIndex = ScriptExecutor.processTokenValue(data, tokenIndex, fragments);
                tokenIndex = -1;
                if (currentIndex >= data.length()) continue;
                tokenIndex = data.indexOf("//ACTIVE_JS_SRC:", currentIndex);
lbl16:
                // 3 sources

                ** while (tokenIndex != -1)
            }
lbl17:
            // 1 sources

            if (currentIndex < data.length()) {
                fragment = data.substring(currentIndex).trim();
                fragments.put(ScriptExecutor.createKey(fragment), fragment);
            }
        }
        return fragments;
    }

    private static String createKey(String data) {
        String id = data;
        if (data.length() > 50) {
            id = data.substring(0, 50);
        }
        return "[" + id + " ...]_" + data.length() + "_" + data.hashCode();
    }

    private static int processTokenValue(String data, int tokenIndex, Map<String, String> fragments) {
        String url;
        int start = tokenIndex + "//ACTIVE_JS_SRC:".length() + 1;
        int end = data.indexOf("]", start);
        String fileName = url = data.substring(start, end);
        if (url.startsWith("file:")) {
            try {
                File file;
                int index = url.indexOf("/bin/");
                String srcUrl = url;
                if (index > 0) {
                    srcUrl = String.valueOf(url.substring(0, index)) + "/src/" + url.substring(index + 5);
                }
                if ((file = new File(new URL(srcUrl).getFile())).exists()) {
                    fileName = file.toURL().toExternalForm();
                    url = srcUrl;
                }
            }
            catch (MalformedURLException e) {
                throw new DsfRuntimeException(url, (Throwable)e);
            }
        }
        String text = ScriptExecutor.getJsContent(url);
        fragments.put(fileName, text);
        return ++end;
    }

    public static String getJsContent(String url) {
        InputStream inputStream;
        try {
            inputStream = new URL(url).openStream();
        }
        catch (IOException e) {
            throw new DsfRuntimeException(url, (Throwable)e);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        try {
            try {
                int numBytesXferred;
                while ((numBytesXferred = inputStream.read(buffer)) != -1) {
                    os.write(buffer, 0, numBytesXferred);
                }
            }
            finally {
                inputStream.close();
            }
            String scriptText = os.toString("utf-8");
            return scriptText;
        }
        catch (IOException e) {
            throw new DsfRuntimeException("can not load '" + url + "'", (Throwable)e);
        }
    }
}

