/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AAttr;
import org.eclipse.vjet.dsf.active.dom.html.ADOMException;
import org.eclipse.vjet.dsf.active.dom.html.ADocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.ANamedNodeMap;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.dom.html.ANodeList;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.jsnative.Attr;
import org.eclipse.vjet.dsf.jsnative.Element;
import org.eclipse.vjet.dsf.jsnative.NamedNodeMap;
import org.eclipse.vjet.dsf.jsnative.NodeList;
import org.eclipse.vjet.dsf.jsnative.TypeInfo;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class AElement
extends ANode
implements Element {
    private static final long serialVersionUID = 1L;
    private NamedNodeMap m_attributes = new ANamedNodeMap(2);
    protected static final String JS_BODY_PATH = "document.getElementById('body')";
    protected static final String JS_OFFSET_PARENT_PATH = "DLC_getPath({0}.offsetParent)";

    public AElement(ADocument doc, DElement element) {
        super(doc, (DNode)element);
        this.populateScriptable(AElement.class, BrowserType.NONE);
    }

    protected AElement(AHtmlDocument doc, DElement element) {
        super(doc, (DNode)element);
        this.populateScriptable(AElement.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    public Object __getAttribute(Object sAttrName, Object iFlags, Object notreq1, Object notreq2, Object notreq3) {
        if (sAttrName instanceof String && iFlags instanceof Integer) {
            return this.getAttribute((String)sAttrName, (Integer)iFlags);
        }
        return this.getAttribute((String)sAttrName);
    }

    public String getAttribute(String name) {
        return this.getDElement().getAttribute(name);
    }

    public String getAttribute(String name, int iFlags) {
        return this.getDElement().getAttribute(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.getDElement().getAttributeNS(namespaceURI, localName);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.m_attributes;
    }

    public Attr getAttributeNode(String name) {
        Attr aAttr = (Attr)this.m_attributes.getNamedItem(name);
        if (aAttr == null) {
            return null;
        }
        return aAttr;
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        DAttr attr = (DAttr)this.getDElement().getAttributeNodeNS(namespaceURI, localName);
        if (attr == null) {
            return null;
        }
        AAttr aAttr = new AAttr((AHtmlDocument)this.getOwnerDocument(), attr);
        aAttr.setOwnerElement(this);
        return aAttr;
    }

    public NodeList byTag(String name) {
        return this.getElementsByTagName(name);
    }

    public NodeList getElementsByTagName(String name) {
        ANodeList answer = new ANodeList();
        this.getElementsByTagName(name, answer);
        return answer;
    }

    public NodeList byTagNS(String namespaceURI, String localName) {
        return this.getElementsByTagNameNS(namespaceURI, localName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        ANodeList answer = new ANodeList();
        this.getElementByTagNameNS(localName, namespaceURI, answer);
        return answer;
    }

    public String getTagName() {
        return this.getDElement().getTagName();
    }

    public void removeAttribute(String name) throws DOMException {
        try {
            if (this.m_attributes.getNamedItem(name) != null) {
                this.m_attributes.removeNamedItem(name);
            }
            this.getDElement().removeAttribute(name);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public void __setAttribute(Object name, Object value, Object notreq1, Object notreq2, Object notreq3) throws DOMException {
        if (name instanceof String && value instanceof String) {
            this.setAttribute((String)name, (String)value);
        } else {
            this.setAttribute((String)name, value);
        }
    }

    public void setAttribute(String name, Object value) throws DOMException {
        try {
            this.getDElement().setAttribute(name, value.toString());
            AAttr aAttr = new AAttr((AHtmlDocument)this.getOwnerDocument(), (DAttr)this.getDElement().getAttributeNode(name));
            aAttr.setOwnerElement(this);
            this.m_attributes.setNamedItem((org.eclipse.vjet.dsf.jsnative.Node)aAttr);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public void setAttribute(String name, String value) throws DOMException {
        try {
            this.getDElement().setAttribute(name, value);
            AAttr aAttr = new AAttr((AHtmlDocument)this.getOwnerDocument(), (DAttr)this.getDElement().getAttributeNode(name));
            aAttr.setOwnerElement(this);
            this.m_attributes.setNamedItem((org.eclipse.vjet.dsf.jsnative.Node)aAttr);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public boolean hasAttribute(String name) {
        return this.getDElement().hasAttribute(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getDElement().hasAttributeNS(namespaceURI, localName);
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        try {
            this.getDElement().removeAttributeNS(namespaceURI, localName);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        if (oldAttr == null) {
            throw new ADOMException(new DOMException(8, "oldAttr is null"));
        }
        AAttr aAttr = null;
        if (this.m_attributes.getNamedItem(oldAttr.getName()) != null) {
            aAttr = (AAttr)this.m_attributes.removeNamedItem(oldAttr.getName());
        }
        if (aAttr == null) {
            throw new ADOMException(new DOMException(8, "Did not find a node named: " + oldAttr.getName()));
        }
        try {
            this.getDElement().removeAttributeNode((org.w3c.dom.Attr)((DAttr)aAttr.getDNode()));
            aAttr.setOwnerElement(null);
            return aAttr;
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        try {
            this.getDElement().setAttributeNS(namespaceURI, qualifiedName, value);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Attr setAttributeNode(Attr newAttr) {
        if (newAttr == null) {
            return null;
        }
        AAttr aAttr = (AAttr)newAttr;
        aAttr.setOwnerElement(this);
        aAttr.setOwnerDocument((ADocument)super.getOwnerDocument());
        this.m_attributes.setNamedItem((org.eclipse.vjet.dsf.jsnative.Node)aAttr);
        DAttr attr = (DAttr)this.getDElement().setAttributeNode((org.w3c.dom.Attr)((DAttr)aAttr.getDNode()));
        if (attr == null) {
            return null;
        }
        AAttr replacedAttr = (AAttr)this.m_attributes.getNamedItem(attr.getName());
        if (replacedAttr == null) {
            return null;
        }
        replacedAttr.setOwnerElement(null);
        replacedAttr.setOwnerDocument(null);
        return aAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        if (newAttr == null) {
            return null;
        }
        AAttr aAttr = (AAttr)newAttr;
        DAttr attr = (DAttr)this.getDElement().setAttributeNodeNS((org.w3c.dom.Attr)((DAttr)aAttr.getDNode()));
        if (attr == null) {
            return null;
        }
        aAttr = new AAttr((AHtmlDocument)this.getOwnerDocument(), attr);
        aAttr.setOwnerElement(this);
        return aAttr;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        try {
            this.getDElement().setIdAttribute(name, isId);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        throw new ADOMException(new DOMException(9, "setIdAttributeNS not supported"));
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) {
        AAttr aAttr = (AAttr)idAttr;
        try {
            this.getDElement().setIdAttributeNode((org.w3c.dom.Attr)aAttr.getDAttr(), isId);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    @Override
    public short compareDocumentPosition(org.eclipse.vjet.dsf.jsnative.Node other) {
        throw new ADOMException(new DOMException(9, "compareDocumentPosition not supported"));
    }

    @Override
    public String getBaseURI() {
        return this.getDElement().getBaseURI();
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new ADOMException(new DOMException(9, "getFeature not supported"));
    }

    @Override
    public String getTextContent() {
        if (this.m_childNodes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ANode child : this.m_childNodes) {
            sb.append(child.getTextContent());
        }
        return sb.toString();
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public org.eclipse.vjet.dsf.jsnative.Node cloneNode(boolean deep) {
        AElement copy = (AElement)super.cloneNode(deep);
        if (this.m_attributes != null) {
            copy.m_attributes = ((ANamedNodeMap)this.m_attributes).cloneMap();
        }
        return copy;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.getDElement().isDefaultNamespace(namespaceURI);
    }

    @Override
    public boolean isEqualNode(org.eclipse.vjet.dsf.jsnative.Node node) {
        return this.getDElement().isEqualNode((Node)((ANode)node).getDNode());
    }

    @Override
    public boolean isSameNode(org.eclipse.vjet.dsf.jsnative.Node other) {
        return this.getDElement().isSameNode((Node)((ANode)other).getDNode());
    }

    @Override
    public String lookupNamespaceURI(String specifiedPrefix) {
        return this.getDElement().lookupNamespaceURI(specifiedPrefix);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.getDElement().lookupPrefix(namespaceURI);
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    void getElementsByName(String elementName, ANodeList answer) {
        if (this.m_childNodes == null) {
            return;
        }
        for (ANode childx : this.m_childNodes) {
            if (!(childx instanceof AElement)) continue;
            AElement child = (AElement)childx;
            String value = child.getAttribute("name");
            if (elementName.equals(value)) {
                answer.add(child);
            }
            child.getElementsByName(elementName, answer);
        }
    }

    void getElementsByTagName(String name, ANodeList answer) {
        boolean matchesAll = "*".equals(name);
        if (this.m_childNodes == null) {
            return;
        }
        for (ANode childx : this.m_childNodes) {
            if (!(childx instanceof AElement)) continue;
            AElement child = (AElement)childx;
            String childName = child.getNodeName();
            if (matchesAll || childName.equalsIgnoreCase(name)) {
                answer.add(child);
            }
            child.getElementsByTagName(name, answer);
        }
    }

    void getElementByTagNameNS(String name, String nsUri, ANodeList answer) {
        if (this.m_childNodes == null) {
            return;
        }
        if (nsUri == null) {
            this.getElementsByTagName(name, answer);
            return;
        }
        if (name == null) {
            return;
        }
        boolean matchesAllName = "*".equals(name);
        boolean matchesAllUri = "*".equals(nsUri);
        for (ANode childx : this.m_childNodes) {
            if (!(childx instanceof AElement)) continue;
            if (matchesAllName) {
                if (matchesAllUri) {
                    answer.add(childx);
                } else if (nsUri.equals(childx.getNamespaceURI())) {
                    answer.add(childx);
                }
            } else if (childx.getLocalName() != null && childx.getLocalName().equals(name)) {
                if (matchesAllUri) {
                    answer.add(childx);
                } else if (nsUri.equals(childx.getNamespaceURI())) {
                    answer.add(childx);
                }
            }
            ((AElement)childx).getElementByTagNameNS(name, nsUri, answer);
        }
    }

    private DElement getDElement() {
        return (DElement)this.getDNode();
    }

    void setHtmlAttribute(EHtmlAttr attr, boolean value) {
        this.setHtmlAttribute(attr, String.valueOf(value));
    }

    void setHtmlAttribute(EHtmlAttr attr, int value) {
        this.setHtmlAttribute(attr, String.valueOf(value));
    }

    void setHtmlAttribute(EHtmlAttr attr, String value) {
        this.setAttribute(attr.getAttributeName(), value);
    }

    protected int getIntBindingValue(EHtmlAttr attr) {
        String value = this.getBindingValue(attr);
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected String getBindingValue(EHtmlAttr attr) {
        return null;
    }

    String getHtmlAttribute(EHtmlAttr attr) {
        return this.getAttribute(attr.getAttributeName());
    }

    private IBrowserBinding getBrowserBinding() {
        AHtmlDocument doc = (AHtmlDocument)this.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        return doc.getBrowserBinding();
    }

    @Override
    public ADocument getOwnerDocument() {
        return (ADocument)super.getOwnerDocument();
    }

    private BaseHtmlElement getElement() {
        return (BaseHtmlElement)this.getDNode();
    }
}

