/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.active.dom.html.AElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlAnchor;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlApplet;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlArea;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlForm;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlIFrame;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlImage;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlInput;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlObject;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlOption;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlSelect;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTableCell;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTableRow;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTableSection;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTextArea;
import org.eclipse.vjet.dsf.active.dom.html.AImage;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.dom.html.AOption;
import org.eclipse.vjet.dsf.active.dom.html.CollectionIndex;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.IDFormControl;
import org.eclipse.vjet.dsf.jsnative.Element;
import org.eclipse.vjet.dsf.jsnative.HtmlCollection;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.NodeList;
import org.mozilla.mod.javascript.Scriptable;

public class AHtmlCollection
extends ActiveObject
implements HtmlCollection {
    private static final long serialVersionUID = 1L;
    static final short ANCHOR = 1;
    static final short FORM = 2;
    static final short IMAGE = 3;
    static final short APPLET = 4;
    static final short LINK = 5;
    static final short OPTION = 6;
    static final short ROW = 7;
    static final short ELEMENT = 8;
    static final short IFRAME = 9;
    static final short AREA = -1;
    static final short TBODY = -2;
    static final short CELL = -3;
    private short _lookingFor;
    private AElement _topLevel;
    public static final AHtmlCollection EMPTY_COLLECTION = new AHtmlCollection(){
        private static final long serialVersionUID = 1L;

        @Override
        public int getLength() {
            return 0;
        }
    };

    AHtmlCollection(AHtmlElement topLevel, short lookingFor) {
        if (topLevel == null) {
            throw new NullPointerException("HTM011 Argument 'topLevel' is null.");
        }
        this._topLevel = topLevel;
        this._lookingFor = lookingFor;
        this.populateScriptable(AHtmlCollection.class, topLevel.getOwnerDocument().getBrowserType());
    }

    private AHtmlCollection() {
    }

    public int getLength() {
        if (this._topLevel == null) {
            return 0;
        }
        return this.getLength(this._topLevel);
    }

    public AHtmlElement get(String name) {
        return (AHtmlElement)this.get(name, null);
    }

    public Object get(int index, Scriptable start) {
        Object obj = super.get(index, start);
        if (obj != NOT_FOUND) {
            return obj;
        }
        obj = this.item(index);
        if (obj != null) {
            return obj;
        }
        return NOT_FOUND;
    }

    public Object get(String name, Scriptable start) {
        Object obj = super.get(name, start);
        if (obj != NOT_FOUND) {
            return obj;
        }
        int i = 0;
        while (i < this.getLength()) {
            AHtmlElement elem = (AHtmlElement)this.item(i);
            if (name.equals(elem.getAttribute("id"))) {
                return elem;
            }
            if (name.equals(elem.getAttribute("name"))) {
                return elem;
            }
            ++i;
        }
        return NOT_FOUND;
    }

    public void put(int index, Scriptable start, Object value) {
        if (!(value instanceof ANode) && value != null) {
            super.put(index, start, value);
            return;
        }
        Node node = this.item(index);
        if (node != null) {
            this.removeNode(node);
            if (value != null) {
                this.insertNode((Node)value, index);
            }
            return;
        }
        if (index - this.getLength() > 1) {
            this.growCollection(index - this.getLength() - 1, value);
        }
        this.appendNode((Node)value);
    }

    public void put(String name, Scriptable start, Object value) {
        if (!(value instanceof ANode) && value != null) {
            super.put(name, start, value);
            return;
        }
        if ("namedItem".equals(name)) {
            Node node = this.namedItem(name);
            if (node != null) {
                this.removeNode(node);
                if (value != null) {
                    this.appendNode((Node)value);
                }
                return;
            }
            this.appendNode((Node)value);
        }
    }

    public final Node item(int index) {
        if (index < 0) {
            return null;
        }
        return this.item(this._topLevel, new CollectionIndex(index));
    }

    public final Node namedItem(String name) {
        if (name == null) {
            return null;
        }
        return this.namedItem(this._topLevel, name);
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return ((Object)((Object)this)).getClass().getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLength(AElement topLevel) {
        int length;
        AElement aElement = topLevel;
        synchronized (aElement) {
            length = 0;
            Node node = topLevel.getFirstChild();
            while (node != null) {
                if (node instanceof AElement) {
                    if (this.collectionMatch((AElement)node, null)) {
                        ++length;
                    } else if (this.recurse()) {
                        length += this.getLength((AElement)node);
                    }
                }
                node = node.getNextSibling();
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node item(AElement topLevel, CollectionIndex index) {
        AElement aElement = topLevel;
        synchronized (aElement) {
            Node node = topLevel.getFirstChild();
            while (node != null) {
                if (node instanceof AElement) {
                    Node result;
                    if (this.collectionMatch((AElement)node, null)) {
                        if (index.isZero()) {
                            return node;
                        }
                        index.decrement();
                    } else if (this.recurse() && (result = this.item((AElement)node, index)) != null) {
                        return result;
                    }
                }
                node = node.getNextSibling();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node namedItem(AElement topLevel, String name) {
        if (topLevel == null) {
            return null;
        }
        AElement aElement = topLevel;
        synchronized (aElement) {
            Node node = topLevel.getFirstChild();
            while (node != null) {
                if (node instanceof AElement) {
                    Node result;
                    if (this.collectionMatch((AElement)node, name)) {
                        return node;
                    }
                    if (this.recurse() && (result = this.namedItem((AElement)node, name)) != null) {
                        return result;
                    }
                }
                node = node.getNextSibling();
            }
            return node;
        }
    }

    protected boolean recurse() {
        return this._lookingFor > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean collectionMatch(AElement elem, String name) {
        boolean match;
        AElement aElement = elem;
        synchronized (aElement) {
            block18: {
                match = false;
                switch (this._lookingFor) {
                    case 1: {
                        match = elem instanceof AHtmlAnchor && elem.getAttribute("name").length() > 0;
                        break;
                    }
                    case 2: {
                        match = elem instanceof AHtmlForm;
                        break;
                    }
                    case 3: {
                        match = elem instanceof AHtmlImage || elem instanceof AImage;
                        break;
                    }
                    case 4: {
                        match = elem instanceof AHtmlApplet || elem instanceof AHtmlObject && ("application/java".equals(elem.getAttribute("codetype")) || elem.getAttribute("classid").startsWith("java:"));
                        break;
                    }
                    case 8: {
                        match = elem instanceof IDFormControl;
                        break;
                    }
                    case 5: {
                        match = elem instanceof AHtmlAnchor && elem.getAttribute("href").length() > 0;
                        break;
                    }
                    case -1: {
                        match = elem instanceof AHtmlArea;
                        break;
                    }
                    case 6: {
                        match = elem instanceof AHtmlOption || elem instanceof AOption;
                        break;
                    }
                    case 7: {
                        match = elem instanceof AHtmlTableRow;
                        break;
                    }
                    case -2: {
                        match = elem instanceof AHtmlTableSection && elem.getTagName().equalsIgnoreCase("tbody");
                        break;
                    }
                    case -3: {
                        match = elem instanceof AHtmlTableCell;
                        break;
                    }
                    case 9: {
                        match = elem instanceof AHtmlIFrame;
                    }
                }
                if (!match || name == null) break block18;
                match = name.equalsIgnoreCase(elem.getAttribute("id"));
                if (!(elem instanceof AHtmlAnchor) || !name.equalsIgnoreCase(elem.getAttribute("name"))) break block18;
                return true;
            }
        }
        return match;
    }

    private void growCollection(int size, Object value) {
        if (this._topLevel == null) {
            return;
        }
        switch (this._lookingFor) {
            case 1: {
                this.createElements(HtmlTypeEnum.A.getName(), size);
                break;
            }
            case 2: {
                this.createElements(HtmlTypeEnum.FORM.getName(), size);
                break;
            }
            case 3: {
                this.createElements(HtmlTypeEnum.IMG.getName(), size);
                break;
            }
            case 4: {
                this.createElements(HtmlTypeEnum.APPLET.getName(), size);
                break;
            }
            case 8: {
                if (value instanceof AHtmlInput) {
                    this.createElements(HtmlTypeEnum.INPUT.getName(), size);
                    break;
                }
                if (value instanceof AHtmlSelect) {
                    this.createElements(HtmlTypeEnum.SELECT.getName(), size);
                    break;
                }
                if (!(value instanceof AHtmlTextArea)) break;
                this.createElements(HtmlTypeEnum.TEXTAREA.getName(), size);
                break;
            }
            case 5: {
                this.createElements(HtmlTypeEnum.LINK.getName(), size);
                break;
            }
            case -1: {
                this.createElements(HtmlTypeEnum.AREA.getName(), size);
                break;
            }
            case 6: {
                this.createElements(HtmlTypeEnum.OPTION.getName(), size);
                break;
            }
            case 7: {
                this.createElements(HtmlTypeEnum.TR.getName(), size);
                break;
            }
            case -2: {
                this.createElements(HtmlTypeEnum.TBODY.getName(), size);
                break;
            }
            case -3: {
                this.createElements(HtmlTypeEnum.TD.getName(), size);
                break;
            }
            case 9: {
                this.createElements(HtmlTypeEnum.IFRAME.getName(), size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createElements(String tagName, int size) {
        AElement aElement = this._topLevel;
        synchronized (aElement) {
            int i = 0;
            while (i < size) {
                Element e = this._topLevel.getOwnerDocument().createElement(tagName);
                this._topLevel.appendChild((Node)e);
                ++i;
            }
        }
    }

    private void insertNode(Node node, int index) {
        NodeList nl = this._topLevel.getChildNodes();
        Node before = nl.item(index);
        this._topLevel.insertBefore(node, before);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendNode(Node node) {
        AElement aElement = this._topLevel;
        synchronized (aElement) {
            this._topLevel.appendChild(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNode(Node node) {
        AElement aElement = this._topLevel;
        synchronized (aElement) {
            this._topLevel.removeChild(node);
        }
    }

    AElement getTopLevel() {
        return this._topLevel;
    }

    /* synthetic */ AHtmlCollection(AHtmlCollection aHtmlCollection) {
        this();
    }
}

