/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlCollection;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTableCaption;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTableRow;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTableSection;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseTableSection;
import org.eclipse.vjet.dsf.html.dom.DTBody;
import org.eclipse.vjet.dsf.html.dom.DTable;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.jsnative.HtmlCollection;
import org.eclipse.vjet.dsf.jsnative.HtmlTable;
import org.eclipse.vjet.dsf.jsnative.HtmlTableCaption;
import org.eclipse.vjet.dsf.jsnative.HtmlTableRow;
import org.eclipse.vjet.dsf.jsnative.HtmlTableSection;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.w3c.dom.DOMException;

public class AHtmlTable
extends AHtmlElement
implements HtmlTable {
    private static final long serialVersionUID = 1L;
    private AHtmlCollection m_rows;
    private AHtmlCollection m_bodies;

    protected AHtmlTable(AHtmlDocument doc, DTable node) {
        super(doc, (BaseHtmlElement)node);
        this.populateScriptable(AHtmlTable.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    @Override
    public Node cloneNode(boolean deep) {
        AHtmlTable clonedNode = (AHtmlTable)super.cloneNode(deep);
        clonedNode.m_rows = null;
        clonedNode.m_bodies = null;
        return clonedNode;
    }

    public HtmlTableCaption createCaption() {
        AHtmlTableCaption caption = (AHtmlTableCaption)this.getCaption();
        if (caption != null) {
            return caption;
        }
        caption = new AHtmlTableCaption(this.getOwnerDocument(), this.getDTable().htmlCreateCaption());
        this.appendChild(caption, false);
        this.onAppendChild(caption);
        return caption;
    }

    public HtmlTableSection createTFoot() {
        AHtmlTableSection section = (AHtmlTableSection)this.getTFoot();
        if (section != null) {
            return section;
        }
        section = new AHtmlTableSection(this.getOwnerDocument(), (BaseTableSection)this.getDTable().htmlCreateTFoot());
        this.appendChild(section, false);
        this.onAppendChild(section);
        return section;
    }

    public HtmlTableSection createTHead() {
        AHtmlTableSection section = (AHtmlTableSection)this.getTHead();
        if (section != null) {
            return section;
        }
        section = new AHtmlTableSection(this.getOwnerDocument(), (BaseTableSection)this.getDTable().htmlCreateTHead());
        this.appendChild(section, false);
        this.onAppendChild(section);
        return section;
    }

    public void deleteCaption() {
        HtmlTableCaption old = this.getCaption();
        if (old != null) {
            this.removeChild((Node)old);
        }
    }

    public void deleteRow(int index) {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof AHtmlTableRow) {
                if (index == 0) {
                    this.removeChild(child);
                    return;
                }
                --index;
            } else if (child instanceof AHtmlTableSection && (index = ((AHtmlTableSection)child).deleteRowX(index)) < 0) {
                return;
            }
            child = child.getNextSibling();
        }
    }

    public void deleteTBody() {
        HtmlTableSection old = this.getTBody();
        if (old != null) {
            this.removeChild((Node)old);
        }
    }

    public void deleteTFoot() {
        HtmlTableSection old = this.getTFoot();
        if (old != null) {
            this.removeChild((Node)old);
        }
    }

    public void deleteTHead() {
        HtmlTableSection old = this.getTHead();
        if (old != null) {
            this.removeChild((Node)old);
        }
    }

    public String getAlign() {
        return this.getDTable().getHtmlAlign();
    }

    public String getBgColor() {
        return this.getDTable().getHtmlBgColor();
    }

    public String getBorder() {
        return this.getDTable().getHtmlBorder();
    }

    public HtmlTableCaption getCaption() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof AHtmlTableCaption && child.getNodeName().equalsIgnoreCase("caption")) {
                return (HtmlTableCaption)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public String getCellPadding() {
        return this.getDTable().getHtmlCellPadding();
    }

    public String getCellSpacing() {
        return this.getDTable().getHtmlCellSpacing();
    }

    public String getFrame() {
        return this.getDTable().getHtmlFrame();
    }

    public HtmlCollection getRows() {
        if (this.m_rows == null) {
            this.m_rows = new AHtmlCollection(this, 7);
        }
        return this.m_rows;
    }

    public String getRules() {
        return this.getDTable().getHtmlRules();
    }

    public String getSummary() {
        return this.getDTable().getHtmlSummary();
    }

    public HtmlCollection getTBodies() {
        if (this.m_bodies == null) {
            this.m_bodies = new AHtmlCollection(this, -2);
        }
        return this.m_bodies;
    }

    public HtmlTableSection getTFoot() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof AHtmlTableSection && child.getNodeName().equalsIgnoreCase("tfoot")) {
                return (HtmlTableSection)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public HtmlTableSection getTHead() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof AHtmlTableSection && child.getNodeName().equalsIgnoreCase("thead")) {
                return (HtmlTableSection)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public String getWidth() {
        return this.getDTable().getHtmlWidth();
    }

    public HtmlTableRow insertRow(int index) {
        AHtmlTableRow newRow = new AHtmlTableRow(this.getOwnerDocument(), this.getDTable().htmlInsertRow(index));
        this.insertRowX(index, newRow);
        return newRow;
    }

    public void setAlign(String align) {
        this.getDTable().setHtmlAlign(align);
        this.onAttrChange(EHtmlAttr.align, align);
    }

    public void setBgColor(String bgColor) {
        this.getDTable().setHtmlBgColor(bgColor);
        this.onAttrChange(EHtmlAttr.bgcolor, bgColor);
    }

    public void setBorder(String border) {
        this.getDTable().setHtmlBorder(border);
        this.onAttrChange(EHtmlAttr.border, border);
    }

    public void setCaption(HtmlTableCaption caption) {
        if (caption != null && !caption.getTagName().equalsIgnoreCase("caption")) {
            throw new IllegalArgumentException("Argument 'caption' is not an element of type <CAPTION>");
        }
        this.deleteCaption();
        if (caption != null) {
            this.appendChild((Node)caption);
        }
    }

    public void setCellPadding(String cellPadding) {
        this.getDTable().setHtmlCellPadding(cellPadding);
        this.onAttrChange(EHtmlAttr.cellpadding, cellPadding);
    }

    public void setCellSpacing(String spacing) {
        this.getDTable().setHtmlCellSpacing(spacing);
        this.onAttrChange(EHtmlAttr.cellspacing, spacing);
    }

    public void setFrame(String frame) {
        this.getDTable().setHtmlFrame(frame);
        this.onAttrChange(EHtmlAttr.frame, frame);
    }

    public void setRules(String rules) {
        this.getDTable().setHtmlRules(rules);
        this.onAttrChange(EHtmlAttr.rules, rules);
    }

    public void setSummary(String summary) {
        this.getDTable().setHtmlSummary(summary);
        this.onAttrChange(EHtmlAttr.border, summary);
    }

    public void setTFoot(HtmlTableSection tFoot) {
        if (tFoot != null && !tFoot.getTagName().equalsIgnoreCase("tfoot")) {
            throw new IllegalArgumentException("Argument 'tFoot' is not an element of type <TFOOT>");
        }
        this.deleteTFoot();
        if (tFoot != null) {
            this.appendChild((Node)tFoot);
        }
    }

    public void setTHead(HtmlTableSection tHead) {
        if (tHead != null && !tHead.getTagName().equalsIgnoreCase("thead")) {
            throw new IllegalArgumentException("Argument 'tHead' is not an element of type <THEAD>");
        }
        this.deleteTHead();
        if (tHead != null) {
            this.appendChild((Node)tHead);
        }
    }

    public void setWidth(String width) {
        this.getDTable().setHtmlWidth(width);
        this.onAttrChange(EHtmlAttr.width, width);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild instanceof AHtmlTableRow) {
            HtmlTableSection tBody = this.getTBody();
            if (tBody == null) {
                tBody = this.createTBody();
            }
            tBody.appendChild(newChild);
        } else {
            super.appendChild(newChild);
        }
        return newChild;
    }

    @Override
    void appendChild(ANode newChild, boolean deep) throws DOMException {
        if (newChild instanceof AHtmlTableRow) {
            HtmlTableSection tBody = this.getTBody();
            if (tBody == null) {
                tBody = this.createTBody();
            }
            tBody.insertRow(-1);
        } else {
            super.appendChild(newChild, deep);
        }
    }

    void insertRowX(int index, AHtmlTableRow newRow) {
        ANode lastSection = null;
        ANode child = (ANode)this.getFirstChild();
        while (child != null) {
            if (child instanceof AHtmlTableRow) {
                if (index == 0) {
                    this.insertBefore(newRow, child, false);
                    return;
                }
                --index;
            } else if (child instanceof AHtmlTableSection && ((BaseTableSection)child.getDNode()).isHtmlTableBody()) {
                lastSection = child;
                if ((index = ((AHtmlTableSection)child).insertRowX(index, newRow)) < 0) {
                    return;
                }
            }
            child = (ANode)child.getNextSibling();
        }
        if (lastSection != null) {
            lastSection.appendChild(newRow, false);
        } else {
            this.appendChild(newRow, false);
        }
        this.onAppendChild(newRow);
    }

    private HtmlTableSection getTBody() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof AHtmlTableSection && child.getNodeName().equalsIgnoreCase("tbody")) {
                return (HtmlTableSection)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public HtmlTableSection createTBody() {
        DTBody tb = new DTBody();
        this.getDTable().add((DNode)tb);
        AHtmlTableSection tBody = new AHtmlTableSection(this.getOwnerDocument(), (BaseTableSection)tb);
        super.appendChild(tBody);
        this.onAppendChild(tBody);
        return tBody;
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public Object getOnresize() {
        return this.getOnResize();
    }

    public void setOnresize(Object functionRef) {
        this.setOnResize(functionRef);
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }

    private DTable getDTable() {
        return (DTable)this.getDNode();
    }
}

