/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.proxy;

import org.eclipse.vjet.dsf.dap.proxy.NativeJsHelper;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.IJsJavaProxy;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class NativeJsProxy
implements IJsJavaProxy {
    private Scriptable m_nativeObj;

    protected NativeJsProxy(Scriptable nativeObj) {
        this.init(nativeObj);
    }

    protected NativeJsProxy(Object ... args) {
        Context ctx = NativeJsHelper.getContext();
        Scriptable scope = NativeJsHelper.getScope();
        String clzType = this.getClass().getName();
        Function nativeType = (Function)ctx.evaluateString(scope, clzType, clzType, 0, null);
        this.init(nativeType.construct(ctx, scope, NativeJsHelper.toNatives(args)));
    }

    public Scriptable getJsNative() {
        return this.m_nativeObj;
    }

    protected void callWithName(String methodName, Object ... args) {
        this.execInstanceMethod(methodName, args);
    }

    protected <T> T callWithName(String methodName, Class<T> rtnType, Object ... args) {
        Object result = this.execInstanceMethod(methodName, args);
        return NativeJsHelper.convert(rtnType, result);
    }

    protected <T> T getProperty(String name, Class<T> rtnType) {
        Object result = ScriptableObject.getProperty((Scriptable)this.m_nativeObj, (String)name);
        return NativeJsHelper.convert(rtnType, result);
    }

    protected void setProperty(String name, Object value) {
        ScriptableObject.putProperty((Scriptable)this.m_nativeObj, (String)name, (Object)NativeJsHelper.toNative(value));
    }

    protected static <T> T getStaticProperty(String clzName, String name, Class<T> rtnType) {
        Object result = ScriptableObject.getProperty((Scriptable)NativeJsHelper.getNativeClzType(clzName), (String)name);
        return NativeJsHelper.convert(rtnType, result);
    }

    protected static void setStaticProperty(String clzName, String name, Object value) {
        ScriptableObject.putProperty((Scriptable)NativeJsHelper.getNativeClzType(clzName), (String)name, (Object)NativeJsHelper.toNative(value));
    }

    protected static void callStaticWithName(String clzName, String name, Object ... args) {
        NativeJsProxy.execStaticMethod(clzName, name, args);
    }

    protected static <T> T callStaticWithName(String clzName, String name, Class<T> rtnType, Object ... args) {
        Object result = NativeJsProxy.execStaticMethod(clzName, name, args);
        return NativeJsHelper.convert(rtnType, result);
    }

    private void init(Scriptable nativeObj) {
        this.m_nativeObj = nativeObj;
        nativeObj.put("_js_java_proxy", nativeObj, (Object)this);
    }

    private Object execInstanceMethod(String methodName, Object ... args) {
        Function nativeFunc = (Function)ScriptableObject.getProperty((Scriptable)this.m_nativeObj, (String)methodName);
        return nativeFunc.call(NativeJsHelper.getContext(), NativeJsHelper.getScope(), this.m_nativeObj, NativeJsHelper.toNatives(args));
    }

    private static Object execStaticMethod(String clzName, String methodName, Object ... args) {
        Scriptable nativeType = NativeJsHelper.getNativeClzType(clzName);
        Function nativeFunc = (Function)ScriptableObject.getProperty((Scriptable)nativeType, (String)methodName);
        return nativeFunc.call(NativeJsHelper.getContext(), NativeJsHelper.getScope(), nativeType, NativeJsHelper.toNatives(args));
    }
}

