/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.rt.DLCMsgHandlerRegistry;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserBridge;
import org.eclipse.vjet.dsf.dap.rt.DapCaptureReplay;
import org.eclipse.vjet.dsf.dap.rt.DapConfig;
import org.eclipse.vjet.dsf.dap.rt.DapConsole;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapEventMsgHandler;
import org.eclipse.vjet.dsf.dap.rt.DapSession;
import org.eclipse.vjet.dsf.dap.rt.IBrowserEmulatorListener;
import org.eclipse.vjet.dsf.dap.rt.IDLCMsgHandler;
import org.eclipse.vjet.dsf.html.ctx.HtmlContextHelper;
import org.eclipse.vjet.dsf.html.ctx.HtmlCtx;
import org.eclipse.vjet.dsf.html.events.EventHandlerContainer;
import org.eclipse.vjet.dsf.liveconnect.DLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.client.DLCJsAggregator;
import org.eclipse.vjet.dsf.liveconnect.client.DLCResourceHolder;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;

public final class DapBrowserEmulator {
    private static final Pattern nsPattern = Pattern.compile("^\\[(\\w+)\\]");
    private DapConfig m_dapConfig;
    private DapBrowserBridge m_browserBridge;
    private WeakHashMap<SocketChannel, DapSession> m_channelSessions = new WeakHashMap();
    private WeakHashMap<String, DapSession> m_sessions = new WeakHashMap();
    private String m_curReqId;
    private DapConsole m_console;
    private List<IBrowserEmulatorListener> m_listeners = new ArrayList<IBrowserEmulatorListener>(1);

    DapBrowserEmulator() throws IOException {
        this(new DapConfig());
    }

    DapBrowserEmulator(DapConfig config) throws IOException {
        this.m_dapConfig = config == null ? new DapConfig() : config;
        this.m_browserBridge = new DapBrowserBridge(this);
        this.m_console = new DapConsole(this);
        Thread ct = new Thread(this.m_console);
        ct.setDaemon(true);
        ct.start();
    }

    public DapConfig getDapConfig() {
        return this.m_dapConfig;
    }

    public void addListener(IBrowserEmulatorListener listener) {
        this.m_listeners.add(listener);
    }

    DapSession getSession(String sessionId) {
        return this.getSession(sessionId, false);
    }

    Map<String, DapSession> getSessions() {
        return Collections.unmodifiableMap(this.m_sessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHtml(String sessionId, String reqId, String url, String html) {
        DapCtx ctx = DapCtx.ctx();
        this.m_curReqId = reqId;
        DapBrowserEmulator dapBrowserEmulator = this;
        synchronized (dapBrowserEmulator) {
            this.getSession(sessionId, true).addView(reqId, url, html, ctx, DsfCtx.ctx());
        }
    }

    IDLCClient getDlcClient() {
        return this.m_dapConfig.getDlcClient();
    }

    DLCJsAggregator getJsAggregator() {
        return this.m_dapConfig.getJsAggregator();
    }

    DLCResourceHolder getResourceHolder() {
        return this.m_dapConfig.getResourceHolder();
    }

    DapBrowserBridge getBrowserBridge() {
        return this.m_browserBridge;
    }

    DapCaptureReplay getCaptureReplay() {
        DapSession session = DapCtx.ctx().getSession();
        return session == null ? null : session.getCaptureReplay();
    }

    void onConnect(SocketChannel channel) {
    }

    void onReceive(SocketChannel channel, String msg) {
        boolean onload;
        DapSession session = this.m_channelSessions.get(channel);
        DLCDispatcher dispatcher = null;
        boolean bl = onload = session == null;
        if (onload) {
            try {
                this.onload(msg, channel);
                session = this.m_channelSessions.get(channel);
            }
            catch (Exception e) {
                throw new DsfRuntimeException("Failure during load event: " + msg, (Throwable)e);
            }
        }
        dispatcher = session.getDLCDispatcher();
        DLCMsgHandlerRegistry registry = this.m_dapConfig.getDlcMsgHandlerRegistry();
        Matcher matcher = nsPattern.matcher(msg);
        if (matcher.find()) {
            String name = matcher.group(1);
            IDLCMsgHandler handler = registry.get(name);
            if (handler != null) {
                try {
                    handler.handle(msg, session, (IDLCDispatcher)dispatcher);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            DapEventMsgHandler.getInstance().handle(msg, session, (IDLCDispatcher)dispatcher);
        }
        if (onload) {
            for (IBrowserEmulatorListener listener : this.m_listeners) {
                listener.windowOnload();
            }
        }
    }

    void onClose(SocketChannel channel) {
        DapSession session = this.m_channelSessions.remove(channel);
        if (session != null) {
            this.m_console.onUnload(session);
            session.onUnload();
        }
        this.resetThreadLocalContext();
    }

    public void shutdown() {
        if (this.m_browserBridge != null) {
            this.m_browserBridge.shoudown();
            this.m_browserBridge = null;
        }
    }

    void resetThreadLocalContext() {
        DapCtx.setCtx(null);
        DsfCtx.setCtx(null);
    }

    private synchronized DapSession getSession(String sessionId, boolean create) {
        DapSession session = this.m_sessions.get(sessionId);
        if (session == null && create) {
            session = new DapSession(this, sessionId);
            this.m_sessions.put(sessionId, session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onload(String payload, SocketChannel channel) {
        String sessionId = this.getDlcClient().getSessionId(payload);
        if (sessionId == null) {
            throw new DsfRuntimeException("sessionId is null for event:" + payload);
        }
        String reqId = this.getDlcClient().getReqId(payload);
        if (reqId == null) {
            reqId = this.m_curReqId;
        }
        DapSession session = this.getSession(sessionId);
        session.onLoad(reqId, channel);
        DapBrowserEmulator dapBrowserEmulator = this;
        synchronized (dapBrowserEmulator) {
            this.m_channelSessions.put(channel, session);
        }
        DapCaptureReplay captureReplay = this.getCaptureReplay();
        if (captureReplay != null) {
            captureReplay.connected();
        }
        this.m_console.onload(session);
    }

    static class HtmlCtxHelper
    extends ContextHelper {
        HtmlCtxHelper() {
        }

        static void setContainer(EventHandlerContainer eventHandlerContainer) {
            HtmlContextHelper.setEventHandlerContainer((HtmlCtx)HtmlCtx.ctx(), (EventHandlerContainer)eventHandlerContainer);
        }
    }
}

