/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.dom.html.ADocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlObject;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHttpRequest;
import org.eclipse.vjet.dsf.dap.rt.DapHttpResponse;
import org.eclipse.vjet.dsf.dap.rt.FlashProxy;
import org.eclipse.vjet.dsf.dap.rt.IDapHttpClient;
import org.eclipse.vjet.dsf.html.dom.DObject;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.service.PayloadTypeEnum;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.NativeArray;
import org.mozilla.mod.javascript.NativeObject;
import org.mozilla.mod.javascript.Scriptable;

public class DapFlashProxy
extends AHtmlObject
implements FlashProxy,
IDapHttpClient.IDapCallback {
    private static final long serialVersionUID = 1L;
    private static final long DEFAULT_TIMEOUT = 2000L;
    private String m_respMarshalling;
    private long m_timeout;

    public DapFlashProxy(AHtmlDocument doc, DObject node) {
        super(doc, node);
        this.populateScriptable(DapFlashProxy.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    @Override
    public void onRemoteCall(NativeObject msg) {
        System.out.println("DapFlashProxy::onRemoteCall," + msg);
        NativeObject req = (NativeObject)msg.get("request", null);
        NativeObject cfg = (NativeObject)msg.get("svcConfig", null);
        String svcUrl = (String)req.get("serviceUrl", (Scriptable)req);
        NativeArray headers = (NativeArray)req.get("headers", (Scriptable)req);
        String method = (String)cfg.get("method", (Scriptable)cfg);
        this.m_respMarshalling = (String)cfg.get("respMarshalling", (Scriptable)cfg);
        try {
            this.m_timeout = Long.parseLong((String)cfg.get("timeout", (Scriptable)cfg));
        }
        catch (Exception exception) {
            this.m_timeout = 2000L;
        }
        DapHttpRequest dhr = new DapHttpRequest(method, svcUrl);
        dhr.setTimeout(this.m_timeout);
        if (headers.getLength() > 0L) {
            int i = 0;
            while ((long)i < headers.getLength()) {
                NativeObject h = (NativeObject)headers.get(i, null);
                String name = (String)h.get("name", null);
                String value = (String)h.get("value", null);
                dhr.setRequestHeader(name, value);
                ++i;
            }
        }
        DapCtx.ctx().getDapConfig().getHttpClient().send(dhr, this);
    }

    @Override
    public void onComplete(DapHttpResponse resp) {
        if (resp == null) {
            System.out.println("DapFlashProxy::onComplete: null");
            return;
        }
        System.out.println("DapFlashProxy::onComplete," + resp.getResponseText());
        try {
            AWindow window = DapCtx.ctx().getWindow();
            Function callback = (Function)this.get("callback", null);
            if (!callback.equals(NOT_FOUND)) {
                Object[] args = null;
                if (this.m_respMarshalling == null) {
                    args = new Object[]{};
                } else if (this.m_respMarshalling.equals(PayloadTypeEnum.XML.getName()) || this.m_respMarshalling.equals(PayloadTypeEnum.SOAP.getName())) {
                    ADocument xmlDoc = resp.getResponseXML();
                    args = new Object[]{xmlDoc};
                } else {
                    String respStr = resp.getResponseText();
                    args = new Object[]{respStr};
                }
                callback.call(window.getContext(), callback.getParentScope(), callback.getParentScope(), args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onTimedOut() {
    }
}

