/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.client.ScriptExecutor;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHostMessage;
import org.eclipse.vjet.dsf.dap.svc.IDapSvcCallback;
import org.eclipse.vjet.dsf.html.js.IJsContentGenerator;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.dsf.service.IServiceSpec;
import org.eclipse.vjet.dsf.service.ServiceIdHelper;
import org.eclipse.vjet.dsf.service.client.IClientServiceHandlerRegistry;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public final class DapServiceEngine {
    private Map<String, List<IDapSvcCallback>> m_respHandlers = new LinkedHashMap<String, List<IDapSvcCallback>>();
    private static final String PTY_DAP_HOST_MSG = "dapHostMsg";
    private static final String SVC_RESP_HANDLER_REG_0 = "var _s=vjo.dsf.ServiceEngine, $se=_s.register;var _r=vjo.Registry;";
    private static final String SVC_RESP_HANDLER_REG_01 = "$se(1,\"{0}\",function(message) ";
    private static final String SVC_RESP_HANDLER_REG_02 = "{message.trspType =\"Remote\"; message.v = \"1\"; message.svcConfig = new vjo.dsf.SvcConfig(\"GET\", \"/V4Ajax\"); message.svcConfig.reqtMarshalling = \"JSON\"; message.svcConfig.respMarshalling = \"JSON\";});";
    private static final String SVC_RESP_HANDLER_REG_1 = "$se(4,\"{0}\",function (message) ";
    private static final String SVC_RESP_HANDLER_REG_2 = "{";
    private static final String SVC_RESP_HANDLER_REG_3 = "dapHost.getSvcRespHandlers(\"{0}\")[{1}].onResponse(message); ";
    private static final String SVC_RESP_HANDLER_REG_4 = "});";
    private static final String SCRIPT_PUBLISH_MSG = "vjo.dsf.ServiceEngine.handleRequest(dapHostMsg);";

    public static void subscribe(IServiceSpec svcSpec, IDapSvcCallback handler) {
        DapCtx dapCtx = DapCtx.ctx();
        dapCtx.getDsfSvcRegistry().registerSvcReqHandler(svcSpec);
        dapCtx.getServiceEngine().register(svcSpec.getServiceName(), handler);
    }

    public static void subscribe(IServiceSpec svcSpec, String opName, IDapSvcCallback handler) {
        DapCtx dapCtx = DapCtx.ctx();
        dapCtx.getDsfSvcRegistry().registerSvcReqHandler(svcSpec, opName);
        dapCtx.getServiceEngine().register(svcSpec.getServiceName(), opName, handler);
    }

    public static void publish(String svcName, String opName, Object request) {
        DapCtx.ctx().getServiceEngine().handleRequest(ServiceIdHelper.createServiceId((String)svcName, (String)opName), request, -1);
    }

    public static void publish(IServiceSpec svcSpec, Object request) {
        DapCtx.ctx().getServiceEngine().handleRequest(svcSpec.getServiceName(), request, -1);
    }

    public static void publish(IServiceSpec svcSpec, String opName, Object request) {
        DapCtx.ctx().getServiceEngine().handleRequest(ServiceIdHelper.createServiceId((String)svcSpec.getServiceName(), (String)opName), request, -1);
    }

    public static void publish(IServiceSpec svcSpec, String opName, Object request, IDapSvcCallback callback) {
        DapCtx dapCtx = DapCtx.ctx();
        String svcId = ServiceIdHelper.createServiceId((String)svcSpec.getServiceName(), (String)opName);
        int handlerIndex = dapCtx.getServiceEngine().register(svcId, callback);
        dapCtx.getServiceEngine().handleRequest(svcId, request, handlerIndex);
    }

    private int register(String svcName, String opName, IDapSvcCallback handler) {
        return this.register(ServiceIdHelper.createServiceId((String)svcName, (String)opName), handler);
    }

    private int register(String svcId, IDapSvcCallback handler) {
        DapCtx dapCtx = DapCtx.ctx();
        IClientServiceHandlerRegistry registry = dapCtx.getDsfSvcRegistry();
        if (DapCtx.ctx().isActiveMode()) {
            List<IDapSvcCallback> callbacks = this.getResponseHandlers(svcId, true);
            int i = 0;
            while (i < callbacks.size()) {
                if (callbacks.get(i) == handler) {
                    return i;
                }
                ++i;
            }
            int index = this.add(svcId, handler);
            if (index >= 0) {
                if (dapCtx.getDapHost() == null) {
                    registry.registerSvcRespHandler(svcId, handler.getSvcCallbackAdapter(svcId, index));
                } else {
                    dapCtx.getDapHost().registerSvcHandler(svcId, handler);
                }
            }
            return index;
        }
        IJsFunc callback = null;
        if (handler.getProxySvcCallbacks() != null) {
            callback = handler.getProxySvcCallbacks().get(svcId);
        }
        if (callback != null) {
            registry.registerSvcRespHandler(svcId, (IJsContentGenerator)callback);
            return -1;
        }
        throw new DsfRuntimeException("js proxy handlers are required for non-active mode: mode=" + (Object)((Object)DapCtx.ctx().getExeMode()) + ", svcId=" + svcId + ", handlerType=" + handler.getClass().getName());
    }

    private void handleRequest(String svcId, Object request, int index) {
        DapHostMessage hostMsg = new DapHostMessage();
        hostMsg.setSvcId(svcId);
        hostMsg.setRequest(request);
        this.executeJsPublish(hostMsg, svcId, index);
    }

    List<IDapSvcCallback> getResponseHandlers(String id) {
        List<IDapSvcCallback> list = this.getResponseHandlers(id, false);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    synchronized Map<String, List<IDapSvcCallback>> getAllResponseHandlers() {
        return Collections.unmodifiableMap(this.m_respHandlers);
    }

    private synchronized int add(String elemId, IDapSvcCallback listener) {
        if (elemId == null) {
            return -1;
        }
        List<IDapSvcCallback> listeners = this.getResponseHandlers(elemId, true);
        if (!listeners.contains(listener)) {
            listeners.add(listener);
            return listeners.size() - 1;
        }
        return -1;
    }

    private synchronized List<IDapSvcCallback> getResponseHandlers(String id, boolean create) {
        if (id == null) {
            return Collections.emptyList();
        }
        List<IDapSvcCallback> list = this.m_respHandlers.get(id);
        if (list == null) {
            if (!create) {
                return Collections.emptyList();
            }
            list = new ArrayList<IDapSvcCallback>(2);
            this.m_respHandlers.put(id, list);
        }
        return list;
    }

    private void executeJsPublish(DapHostMessage msg, String svcId, int index) {
        try {
            AWindow window = DapCtx.ctx().getWindow();
            Object wrappedOut = Context.javaToJS((Object)msg, (Scriptable)window);
            ScriptableObject.putProperty((Scriptable)window, (String)PTY_DAP_HOST_MSG, (Object)wrappedOut);
            StringBuilder sb = new StringBuilder();
            if (index >= 0) {
                sb.append(SVC_RESP_HANDLER_REG_0);
                sb.append(MessageFormat.format(SVC_RESP_HANDLER_REG_01, svcId));
                sb.append(SVC_RESP_HANDLER_REG_02);
                sb.append(MessageFormat.format(SVC_RESP_HANDLER_REG_1, svcId));
                sb.append(SVC_RESP_HANDLER_REG_2);
                sb.append(MessageFormat.format(SVC_RESP_HANDLER_REG_3, svcId, String.valueOf(index)));
                sb.append(SVC_RESP_HANDLER_REG_4);
            }
            sb.append(SCRIPT_PUBLISH_MSG);
            String script = sb.toString();
            System.out.println("Rhino => " + script);
            ScriptExecutor.executeScript(script, window);
        }
        catch (Exception e) {
            DapCtx.ctx().getDapConfig().getInfoCollector().log("Fail to execute JS service request", e);
        }
    }
}

