/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.util.Vector;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.dom.DForm;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DInput;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.dom.DTextArea;
import org.eclipse.vjet.dsf.html.js.JSInput;
import org.eclipse.vjet.dsf.html.js.JSSelect;
import org.eclipse.vjet.dsf.html.js.JSTextArea;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class JSFormElementArray
extends ScriptableObject {
    private JSWindow window = null;
    private DForm form = null;
    private Context cx = null;
    private Scriptable scope = null;
    private Vector elements = new Vector();

    private JSFormElementArray() {
    }

    public JSFormElementArray(JSWindow window, DForm form) {
        this.window = window;
        this.form = form;
        this.cx = window.getContext();
        this.scope = window.getScope();
    }

    public String getClassName() {
        return "JSFormElementArray";
    }

    public boolean has(String name, Scriptable start) {
        return name.equals("length");
    }

    public boolean has(int index, Scriptable start) {
        DHtmlCollection elems = this.form.getHtmlElements();
        if (elems == null) {
            return false;
        }
        return index >= 0 && index < elems.getLength();
    }

    public Object get(String name, Scriptable start) {
        if (this.window.windowState == JSWindow.IN_LOADING) {
            DHtmlCollection elems = this.form.getHtmlElements();
            if (name.equals("length")) {
                if (elems != null) {
                    return new Integer(elems.getLength());
                }
                return new Integer(0);
            }
            if (elems == null) {
                return Scriptable.NOT_FOUND;
            }
        } else {
            Object object = this.findElemObject(name);
            if (object != null) {
                return object;
            }
        }
        return Scriptable.NOT_FOUND;
    }

    public Object get(int index, Scriptable start) {
        if (this.window.windowState == JSWindow.IN_LOADING) {
            DHtmlCollection elems = this.form.getHtmlElements();
            if (elems != null && index >= 0 && index < elems.getLength()) {
                return Context.toObject((Object)elems.item(index), (Scriptable)this.scope);
            }
        } else if (index >= 0 && index < this.elements.size()) {
            return Context.toObject(this.elements.get(index), (Scriptable)this.scope);
        }
        return Scriptable.NOT_FOUND;
    }

    public void add(Object element) {
        this.elements.add(element);
    }

    public Object findElemObject(String name) {
        int numElems = this.elements.size();
        int i = 0;
        while (i < numElems) {
            Object elem = this.elements.get(i);
            if (elem instanceof JSInput ? ((JSInput)((Object)elem)).name.equals(name) : (elem instanceof JSSelect ? ((JSSelect)((Object)elem)).name.equals(name) : elem instanceof JSTextArea && ((JSTextArea)((Object)elem)).name.equals(name))) {
                return elem;
            }
            ++i;
        }
        if (this.window.windowState == JSWindow.IN_LOADING) {
            DHtmlCollection elems = this.form.getHtmlElements();
            numElems = elems.getLength();
            int i2 = 0;
            while (i2 < numElems) {
                DElement elem = (DElement)elems.item(i2);
                if (elem instanceof DInput && ((DInput)elem).getHtmlName().equals(name)) {
                    return new JSInput(this.window, (DInput)elem);
                }
                if (elem instanceof DSelect && ((DSelect)elem).getHtmlName().equals(name)) {
                    return new JSSelect(this.window, (DSelect)elem);
                }
                if (elem instanceof DTextArea && ((DTextArea)elem).getHtmlName().equals(name)) {
                    return new JSTextArea(this.window, (DTextArea)elem);
                }
                ++i2;
            }
        }
        return null;
    }
}

