/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DSpan;
import org.eclipse.vjet.dsf.html.js.JSElement;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSSpan
extends JSElement {
    private DSpan span = null;

    public void jsConstructor() {
    }

    @Override
    public String getClassName() {
        return "JSSpan";
    }

    public JSSpan() {
    }

    public JSSpan(JSWindow window, DSpan span) {
        super(window, (BaseHtmlElement)span);
        this.span = span;
        this.defineProperty("innerHTML", JSSpan.class, 2);
    }

    public void setText(String text) {
        DText textNode = this.getTextNode();
        if (text == null || text.length() == 0) {
            if (textNode == null) {
                return;
            }
            this.span.removeChild((Node)textNode);
            this.getChildren().remove(textNode);
        } else {
            if (textNode == null) {
                textNode = new DText();
                this.span.add((DNode)textNode);
                this.getChildren().add(textNode);
            }
            textNode.setTextContent(text);
        }
        this.getListener().onElementChange((BaseHtmlElement)this.span);
    }

    public void setInnerHTML(String text) {
        this.setText(text);
    }

    public String getInnerHTML() {
        String text = null;
        DText textNode = this.getTextNode();
        if (textNode != null) {
            text = textNode.getTextContent();
        }
        return text == null ? "" : text;
    }

    private DText getTextNode() {
        NodeList children = this.span.getChildNodes();
        if (children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i) instanceof DText) {
                    return (DText)children.item(i);
                }
                ++i;
            }
        }
        return null;
    }
}

