/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.eclipse.vjet.dsf.css.dom.impl.DCssException;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRuleList;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class DCssMediaRule
extends DCssRule
implements CSSMediaRule,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private MediaList m_media = null;
    private CSSRuleList m_rules = null;

    public DCssMediaRule(CSSStyleSheet parentStyleSheet, CSSRule parentRule, MediaList media) {
        super(parentStyleSheet, parentRule);
        this.m_media = media;
    }

    @Override
    public short getType() {
        return 4;
    }

    @Override
    public String getCssText() {
        StringBuffer sb = new StringBuffer("@media ");
        sb.append(this.getMedia().toString()).append(" {");
        int i = 0;
        while (i < this.getCssRules().getLength()) {
            CSSRule rule = this.getCssRules().item(i);
            sb.append(rule.getCssText()).append(" ");
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.m_parentStyleSheet != null) {
            throw new DCssException(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            DCssBuilder parser = new DCssBuilder();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 4) {
                throw new DCssException(13, 7);
            }
            this.m_media = ((DCssMediaRule)r).m_media;
            this.m_rules = ((DCssMediaRule)r).m_rules;
        }
        catch (DCssException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this.m_parentStyleSheet;
    }

    @Override
    public CSSRule getParentRule() {
        return this.m_parentRule;
    }

    @Override
    public MediaList getMedia() {
        return this.m_media;
    }

    @Override
    public CSSRuleList getCssRules() {
        return this.m_rules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (this.m_parentStyleSheet != null) {
            throw new DCssException(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(rule));
            DCssBuilder parser = new DCssBuilder();
            parser.setParentStyleSheet(this.m_parentStyleSheet);
            parser.setParentRule(this.m_parentRule);
            CSSRule r = parser.parseRule(is);
            ((DCssRuleList)this.getCssRules()).insert(r, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DCssException(1, 1, e.getMessage());
        }
        catch (DCssException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (this.m_parentStyleSheet != null) {
            throw new DCssException(7, 2);
        }
        try {
            ((DCssRuleList)this.getCssRules()).delete(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DCssException(1, 1, e.getMessage());
        }
    }

    public void setRuleList(CSSRuleList rules) {
        this.m_rules = rules;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

