/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DTr;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.Util;
import org.w3c.dom.Node;

public abstract class BaseTableCell
extends BaseAttrsHtmlElement {
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_CENTER = "center";
    public static final String ALIGN_RIGHT = "right";
    public static final String ALIGN_JUSTIFY = "justify";
    public static final String ALIGN_CHAR = "char";
    public static final String VALIGN_TOP = "top";
    public static final String VALIGN_MIDDLE = "middle";
    public static final String VALIGN_BOTTOM = "bottom";
    public static final String VALIGN_BASELINE = "baseline";
    public static final String SCOPE_ROW = "row";
    public static final String SCOPE_COL = "col";
    public static final String SCOPE_ROWGROUP = "rowgroup";
    public static final String SCOPE_COLGROUP = "colgroup";
    private static final long serialVersionUID = 3256722862214820152L;

    BaseTableCell(HtmlTypeEnum type) {
        super(type);
    }

    BaseTableCell(DHtmlDocument doc, HtmlTypeEnum type) {
        super(doc, type);
    }

    public int getHtmlCellIndex() {
        DNode parent = (DNode)this.getParentNode();
        int index = 0;
        if (parent instanceof DTr) {
            Node child = parent.getFirstChild();
            while (child != null) {
                if (child instanceof BaseTableCell) {
                    if (child == this) {
                        return index;
                    }
                    ++index;
                }
                child = child.getNextSibling();
            }
        }
        return -1;
    }

    public BaseTableCell setHtmlCellIndex(String cellIndex) {
        return this.setHtmlCellIndex(Integer.parseInt(cellIndex));
    }

    public BaseTableCell setHtmlCellIndex(int cellIndex) {
        DNode parent = (DNode)this.getParentNode();
        if (parent instanceof DTr) {
            Node child = parent.getFirstChild();
            while (child != null) {
                if (child instanceof BaseTableCell) {
                    if (cellIndex == 0) {
                        if (this != child) {
                            parent.insertBefore((Node)((Object)this), child);
                        }
                        return this;
                    }
                    --cellIndex;
                }
                child = child.getNextSibling();
            }
        }
        if (parent != null) {
            parent.add((DNode)this);
        }
        return this;
    }

    public String getHtmlAbbr() {
        return this.getHtmlAttribute(EHtmlAttr.abbr);
    }

    public BaseTableCell setHtmlAbbr(String abbr) {
        this.setHtmlAttribute(EHtmlAttr.abbr, abbr);
        return this;
    }

    public String getHtmlAlign() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.align));
    }

    public BaseTableCell setHtmlAlign(String align) {
        this.setHtmlAttribute(EHtmlAttr.align, align);
        return this;
    }

    public String getHtmlAxis() {
        return this.getHtmlAttribute(EHtmlAttr.axis);
    }

    public BaseTableCell setHtmlAxis(String axis) {
        this.setHtmlAttribute(EHtmlAttr.axis, axis);
        return this;
    }

    public String getHtmlBgColor() {
        return this.getHtmlAttribute(EHtmlAttr.bgcolor);
    }

    public BaseTableCell setHtmlBgColor(String bgColor) {
        this.setHtmlAttribute(EHtmlAttr.bgcolor, bgColor);
        return this;
    }

    public String getHtmlCh() {
        return Util.getHtmlCh(this);
    }

    public BaseTableCell setHtmlCh(String _char) {
        Util.setHtmlCh(this, _char);
        return this;
    }

    public String getHtmlChOff() {
        return this.getHtmlAttribute(EHtmlAttr.charoff);
    }

    public BaseTableCell setHtmlChOff(String charoff) {
        this.setHtmlAttribute(EHtmlAttr.charoff, charoff);
        return this;
    }

    public int getHtmlColSpan() {
        return this.getHtmlAttributeInteger(EHtmlAttr.colspan);
    }

    public BaseTableCell setHtmlColSpan(String colspan) {
        this.setHtmlAttribute(EHtmlAttr.colspan, colspan);
        return this;
    }

    public BaseTableCell setHtmlColSpan(int colspan) {
        return this.setHtmlColSpan(String.valueOf(colspan));
    }

    public String getHtmlHeaders() {
        return this.getHtmlAttribute(EHtmlAttr.headers);
    }

    public BaseTableCell setHtmlHeaders(String headers) {
        this.setHtmlAttribute(EHtmlAttr.headers, headers);
        return this;
    }

    public String getHtmlHeight() {
        return this.getHtmlAttribute(EHtmlAttr.height);
    }

    public BaseTableCell setHtmlHeight(String height) {
        this.setHtmlAttribute(EHtmlAttr.height, height);
        return this;
    }

    public BaseTableCell setHtmlHeight(int height) {
        return this.setHtmlHeight(String.valueOf(height));
    }

    public boolean getHtmlNoWrap() {
        return this.getHtmlAttributeExists(EHtmlAttr.nowrap);
    }

    public BaseTableCell setHtmlNoWrap(String noWrap) {
        return this.setHtmlNoWrap(this.toBoolean("nowrap", noWrap));
    }

    public BaseTableCell setHtmlNoWrap(boolean noWrap) {
        this.setHtmlAttribute(EHtmlAttr.nowrap, noWrap);
        return this;
    }

    public int getHtmlRowSpan() {
        return this.getHtmlAttributeInteger(EHtmlAttr.rowspan);
    }

    public BaseTableCell setHtmlRowSpan(String rowspan) {
        this.setHtmlAttribute(EHtmlAttr.rowspan, rowspan);
        return this;
    }

    public BaseTableCell setHtmlRowSpan(int rowspan) {
        return this.setHtmlRowSpan(String.valueOf(rowspan));
    }

    public String getHtmlScope() {
        return this.getHtmlAttribute(EHtmlAttr.scope);
    }

    public BaseTableCell setHtmlScope(String scope) {
        this.setHtmlAttribute(EHtmlAttr.scope, scope);
        return this;
    }

    public String getHtmlValign() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.valign));
    }

    public BaseTableCell setHtmlValign(String valign) {
        this.setHtmlAttribute(EHtmlAttr.valign, valign);
        return this;
    }

    public String getHtmlWidth() {
        return this.getHtmlAttribute(EHtmlAttr.width);
    }

    public BaseTableCell setHtmlWidth(String width) {
        this.setHtmlAttribute(EHtmlAttr.width, width);
        return this;
    }

    public BaseTableCell setHtmlWidth(int width) {
        return this.setHtmlWidth(String.valueOf(width));
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + Z.fmt((String)EHtmlAttr.abbr.getAttributeName(), (Object)this.getHtmlAbbr()) + Z.fmt((String)EHtmlAttr.align.getAttributeName(), (Object)this.getHtmlAlign()) + Z.fmt((String)EHtmlAttr.axis.getAttributeName(), (Object)this.getHtmlAxis()) + Z.fmt((String)EHtmlAttr.bgcolor.getAttributeName(), (Object)this.getHtmlBgColor()) + Z.fmt((String)"cellindex", (Object)("" + this.getHtmlCellIndex())) + Z.fmt((String)EHtmlAttr._char.getAttributeName(), (Object)this.getHtmlCh()) + Z.fmt((String)EHtmlAttr.charoff.getAttributeName(), (Object)this.getHtmlChOff()) + Z.fmt((String)EHtmlAttr.colspan.getAttributeName(), (Object)("" + this.getHtmlColSpan())) + Z.fmt((String)EHtmlAttr.headers.getAttributeName(), (Object)this.getHtmlHeaders()) + Z.fmt((String)EHtmlAttr.height.getAttributeName(), (Object)this.getHtmlHeight()) + Z.fmt((String)EHtmlAttr.nowrap.getAttributeName(), (Object)("" + this.getHtmlNoWrap())) + Z.fmt((String)EHtmlAttr.rowspan.getAttributeName(), (Object)("" + this.getHtmlRowSpan())) + Z.fmt((String)EHtmlAttr.scope.getAttributeName(), (Object)this.getHtmlScope()) + Z.fmt((String)EHtmlAttr.valign.getAttributeName(), (Object)this.getHtmlValign()) + Z.fmt((String)EHtmlAttr.width.getAttributeName(), (Object)this.getHtmlWidth());
    }
}

