/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.event.AbortDsfEventProcessingException;
import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.css.CssClassConstant;
import org.eclipse.vjet.dsf.css.CssIdConstant;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.dom.util.TextChildOperationUtil;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DOption
extends BaseAttrsHtmlElement {
    private static final long serialVersionUID = 3257285846528112436L;

    public DOption() {
        super(HtmlTypeEnum.OPTION);
    }

    public DOption(DHtmlDocument doc) {
        super(doc, HtmlTypeEnum.OPTION);
    }

    public DOption(String textValue) {
        this();
        this.setHtmlExtTextValue(textValue);
    }

    public DOption(String text, String value) {
        this();
        this.setHtmlText(text);
        this.setHtmlValue(value);
    }

    @Override
    public HtmlTypeEnum htmlType() {
        return HtmlTypeEnum.OPTION;
    }

    public boolean getHtmlDefaultSelected() {
        return this.getHtmlAttributeExists(EHtmlAttr.defaultSelected);
    }

    public DOption setHtmlDefaultSelected(boolean defaultSelected) {
        this.setHtmlAttribute(EHtmlAttr.defaultSelected, defaultSelected);
        return this;
    }

    public String getHtmlText() {
        StringBuilder text = new StringBuilder();
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof DText) {
                text.append(((DText)child).getData());
            }
            child = child.getNextSibling();
        }
        return text.toString();
    }

    public DOption setHtmlText(String text) {
        Node child = this.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            this.removeChild(child);
            child = next;
        }
        this.add(text);
        return this;
    }

    public int getHtmlIndex() {
        Node parent = this.getParentNode();
        while (parent != null && !(parent instanceof DSelect)) {
            parent = parent.getParentNode();
        }
        if (parent != null) {
            NodeList options = ((DElement)parent).getElementsByTagName(HtmlTypeEnum.OPTION.getName());
            int i = 0;
            while (i < options.getLength()) {
                if (options.item(i) == this) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public DOption setHtmlIndex(int index) {
        NodeList options;
        Node parent = this.getParentNode();
        while (parent != null && !(parent instanceof DSelect)) {
            parent = parent.getParentNode();
        }
        if (parent != null && (options = ((DElement)parent).getElementsByTagName(HtmlTypeEnum.OPTION.getName())).item(index) != this) {
            this.getParentNode().removeChild((Node)((Object)this));
            Node item = options.item(index);
            item.getParentNode().insertBefore((Node)((Object)this), item);
        }
        return this;
    }

    public boolean getHtmlDisabled() {
        return this.getHtmlAttributeExists(EHtmlAttr.disabled);
    }

    public DOption setHtmlDisabled(String disabled) {
        return this.setHtmlDisabled(this.toBoolean("disabled", disabled));
    }

    public DOption setHtmlDisabled(boolean disabled) {
        this.setHtmlAttribute(EHtmlAttr.disabled, disabled);
        return this;
    }

    public String getHtmlLabel() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.label));
    }

    public DOption setHtmlLabel(String label) {
        this.setHtmlAttribute(EHtmlAttr.label, label);
        return this;
    }

    public boolean getHtmlSelected() {
        return this.getHtmlAttributeExists(EHtmlAttr.selected);
    }

    public DOption setHtmlSelected(String selected) {
        return this.setHtmlSelected(this.toBoolean("selected", selected));
    }

    public DOption setHtmlSelected(boolean selected) {
        this.setHtmlAttribute(EHtmlAttr.selected, selected);
        return this;
    }

    public String getHtmlValue() {
        return this.getHtmlAttribute(EHtmlAttr.value);
    }

    public DOption setHtmlValue(String value) {
        this.setHtmlAttribute(EHtmlAttr.value, value);
        return this;
    }

    public DOption setHtmlExtTextValue(String value) {
        TextChildOperationUtil.setTextValue((DNode)this, (String)value);
        return this;
    }

    public String getHtmlExtTextValue() {
        return TextChildOperationUtil.getTextValue((DNode)this);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + Z.fmt((String)EHtmlAttr.defaultSelected.getAttributeName(), (Object)("" + this.getHtmlDefaultSelected())) + Z.fmt((String)EHtmlAttr.disabled.getAttributeName(), (Object)("" + this.getHtmlDisabled())) + Z.fmt((String)"index", (Object)("" + this.getHtmlIndex())) + Z.fmt((String)EHtmlAttr.label.getAttributeName(), (Object)this.getHtmlLabel()) + Z.fmt((String)EHtmlAttr.selected.getAttributeName(), (Object)("" + this.getHtmlSelected())) + Z.fmt((String)EHtmlAttr.text.getAttributeName(), (Object)this.getHtmlText());
    }

    public DOption add(DNode newChild) throws DOMException {
        super.add(newChild);
        return this;
    }

    public DOption add(String value) throws DOMException {
        super.add(value);
        return this;
    }

    public DOption addRaw(String value) throws DOMException {
        super.addRaw(value);
        return this;
    }

    public DOption dsfAccept(IDNodeVisitor visitor) {
        super.dsfAccept(visitor);
        return this;
    }

    public DOption dsfBroadcast(DsfEvent event) throws AbortDsfEventProcessingException {
        super.dsfBroadcast(event);
        return this;
    }

    public DOption setDsfRelationshipVerifier(IDNodeRelationshipVerifier relationshipVerifier) {
        super.setDsfRelationshipVerifier(relationshipVerifier);
        return this;
    }

    public DOption cloned() {
        return (DOption)((Object)super.cloned());
    }

    public DOption setDsfNamespace(DNamespace namespace) {
        super.setDsfNamespace(namespace);
        return this;
    }

    @Override
    public DOption setHtmlAccessKey(String accessKey) {
        super.setHtmlAccessKey(accessKey);
        return this;
    }

    @Override
    public DOption setHtmlClassName(String className) {
        super.setHtmlClassName(className);
        return this;
    }

    @Override
    public DOption setHtmlClassName(CssClassConstant ccc) {
        super.setHtmlClassName(ccc);
        return this;
    }

    @Override
    public DOption setHtmlContentEditable(String editable) {
        super.setHtmlContentEditable(editable);
        return this;
    }

    @Override
    public DOption setHtmlContextMenu(String contextMenu) {
        super.setHtmlContextMenu(contextMenu);
        return this;
    }

    @Override
    public DOption setHtmlDir(String dir) {
        super.setHtmlDir(dir);
        return this;
    }

    @Override
    public DOption setHtmlDraggable(String draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DOption setHtmlDraggable(boolean draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DOption setHtmlHidden(String hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DOption setHtmlHidden(boolean hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DOption setHtmlId(String id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DOption setHtmlId(CssIdConstant id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DOption setHtmlItem(String item) {
        super.setHtmlItem(item);
        return this;
    }

    @Override
    public DOption setHtmlItemProp(String itemProp) {
        super.setHtmlItemProp(itemProp);
        return this;
    }

    @Override
    public DOption setHtmlLang(String lang) {
        super.setHtmlLang(lang);
        return this;
    }

    @Override
    public DOption setHtmlSpellCheck(String spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DOption setHtmlSpellCheck(boolean spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DOption setHtmlStyleAsString(String styleString) {
        super.setHtmlStyleAsString(styleString);
        return this;
    }

    @Override
    public DOption setHtmlStyle(CSSStyleDeclaration style) {
        super.setHtmlStyle(style);
        return this;
    }

    @Override
    public DOption setHtmlSubject(String subject) {
        super.setHtmlSubject(subject);
        return this;
    }

    @Override
    public DOption setHtmlTabIndex(String tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DOption setHtmlTabIndex(int tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DOption setHtmlTitle(String title) {
        super.setHtmlTitle(title);
        return this;
    }

    @Override
    public DOption setHtmlOnAbort(String script) {
        super.setHtmlOnAbort(script);
        return this;
    }

    @Override
    public DOption setHtmlOnBlur(String onBlur) {
        super.setHtmlOnBlur(onBlur);
        return this;
    }

    @Override
    public DOption setHtmlOnCanPlay(String script) {
        super.setHtmlOnCanPlay(script);
        return this;
    }

    @Override
    public DOption setHtmlOnCanPlayThrough(String script) {
        super.setHtmlOnCanPlayThrough(script);
        return this;
    }

    @Override
    public DOption setHtmlOnChange(String script) {
        super.setHtmlOnChange(script);
        return this;
    }

    @Override
    public DOption setHtmlOnClick(String script) {
        super.setHtmlOnClick(script);
        return this;
    }

    @Override
    public DOption setHtmlOnContextMenu(String script) {
        super.setHtmlOnContextMenu(script);
        return this;
    }

    @Override
    public DOption setHtmlOnDblClick(String script) {
        super.setHtmlOnDblClick(script);
        return this;
    }

    @Override
    public DOption setHtmlOnDrag(String script) {
        super.setHtmlOnDrag(script);
        return this;
    }

    @Override
    public DOption setHtmlOnDragEnd(String script) {
        super.setHtmlOnDragEnd(script);
        return this;
    }

    @Override
    public DOption setHtmlOnDragEnter(String script) {
        super.setHtmlOnDragEnter(script);
        return this;
    }

    @Override
    public DOption setHtmlOnDragLeave(String script) {
        super.setHtmlOnDragLeave(script);
        return this;
    }

    @Override
    public DOption setHtmlOnDragOver(String script) {
        super.setHtmlOnDragOver(script);
        return this;
    }

    @Override
    public DOption setHtmlOnDragStart(String script) {
        super.setHtmlOnDragStart(script);
        return this;
    }

    @Override
    public DOption setHtmlOnDrop(String script) {
        super.setHtmlOnDrop(script);
        return this;
    }

    @Override
    public DOption setHtmlOnDurationChange(String script) {
        super.setHtmlOnDurationChange(script);
        return this;
    }

    @Override
    public DOption setHtmlOnEmptied(String script) {
        super.setHtmlOnEmptied(script);
        return this;
    }

    @Override
    public DOption setHtmlOnEnded(String script) {
        super.setHtmlOnEnded(script);
        return this;
    }

    @Override
    public DOption setHtmlOnError(String script) {
        super.setHtmlOnError(script);
        return this;
    }

    @Override
    public DOption setHtmlOnFocus(String script) {
        super.setHtmlOnFocus(script);
        return this;
    }

    @Override
    public DOption setHtmlOnFormChange(String script) {
        super.setHtmlOnFormChange(script);
        return this;
    }

    @Override
    public DOption setHtmlOnFormInput(String script) {
        super.setHtmlOnFormInput(script);
        return this;
    }

    @Override
    public DOption setHtmlOnInput(String script) {
        super.setHtmlOnInput(script);
        return this;
    }

    @Override
    public DOption setHtmlOnInvalid(String script) {
        super.setHtmlOnInvalid(script);
        return this;
    }

    @Override
    public DOption setHtmlOnKeyDown(String script) {
        super.setHtmlOnKeyDown(script);
        return this;
    }

    @Override
    public DOption setHtmlOnKeyPress(String script) {
        super.setHtmlOnKeyPress(script);
        return this;
    }

    @Override
    public DOption setHtmlOnKeyUp(String script) {
        super.setHtmlOnKeyUp(script);
        return this;
    }

    @Override
    public DOption setHtmlOnLoad(String script) {
        super.setHtmlOnLoad(script);
        return this;
    }

    @Override
    public DOption setHtmlOnLoadedData(String script) {
        super.setHtmlOnLoadedData(script);
        return this;
    }

    @Override
    public DOption setHtmlOnLoadedMetadata(String script) {
        super.setHtmlOnLoadedMetadata(script);
        return this;
    }

    @Override
    public DOption setHtmlOnLoadStart(String script) {
        super.setHtmlOnLoadStart(script);
        return this;
    }

    @Override
    public DOption setHtmlOnMouseDown(String script) {
        super.setHtmlOnMouseDown(script);
        return this;
    }

    @Override
    public DOption setHtmlOnMouseMove(String script) {
        super.setHtmlOnMouseMove(script);
        return this;
    }

    @Override
    public DOption setHtmlOnMouseOut(String script) {
        super.setHtmlOnMouseOut(script);
        return this;
    }

    @Override
    public DOption setHtmlOnMouseOver(String script) {
        super.setHtmlOnMouseOver(script);
        return this;
    }

    @Override
    public DOption setHtmlOnMouseUp(String script) {
        super.setHtmlOnMouseUp(script);
        return this;
    }

    @Override
    public DOption setHtmlOnMouseWheel(String script) {
        super.setHtmlOnMouseWheel(script);
        return this;
    }

    @Override
    public DOption setHtmlOnPause(String script) {
        super.setHtmlOnPause(script);
        return this;
    }

    @Override
    public DOption setHtmlOnPlay(String script) {
        super.setHtmlOnPlay(script);
        return this;
    }

    @Override
    public DOption setHtmlOnPlaying(String script) {
        super.setHtmlOnPlaying(script);
        return this;
    }

    @Override
    public DOption setHtmlOnProgress(String script) {
        super.setHtmlOnProgress(script);
        return this;
    }

    @Override
    public DOption setHtmlOnRateChange(String script) {
        super.setHtmlOnRateChange(script);
        return this;
    }

    @Override
    public DOption setHtmlOnReadyStateChange(String script) {
        super.setHtmlOnReadyStateChange(script);
        return this;
    }

    @Override
    public DOption setHtmlOnScroll(String script) {
        super.setHtmlOnScroll(script);
        return this;
    }

    @Override
    public DOption setHtmlOnSeeked(String script) {
        super.setHtmlOnSeeked(script);
        return this;
    }

    @Override
    public DOption setHtmlOnSeeking(String script) {
        super.setHtmlOnSeeking(script);
        return this;
    }

    @Override
    public DOption setHtmlOnSelect(String script) {
        super.setHtmlOnSelect(script);
        return this;
    }

    @Override
    public DOption setHtmlOnShow(String script) {
        super.setHtmlOnShow(script);
        return this;
    }

    @Override
    public DOption setHtmlOnStalled(String script) {
        super.setHtmlOnStalled(script);
        return this;
    }

    @Override
    public DOption setHtmlOnSubmit(String script) {
        super.setHtmlOnSubmit(script);
        return this;
    }

    @Override
    public DOption setHtmlOnSuspend(String script) {
        super.setHtmlOnSuspend(script);
        return this;
    }

    @Override
    public DOption setHtmlOnTimeUpdate(String script) {
        super.setHtmlOnTimeUpdate(script);
        return this;
    }

    @Override
    public DOption setHtmlOnVolumeChange(String script) {
        super.setHtmlOnVolumeChange(script);
        return this;
    }

    @Override
    public DOption setHtmlOnWaiting(String script) {
        super.setHtmlOnWaiting(script);
        return this;
    }

    @Override
    public DOption add(EventType eventType, ISimpleJsEventHandler handler) {
        super.add(eventType, handler);
        return this;
    }

    @Override
    public DOption add(EventType eventType, IJsFunc func) {
        super.add(eventType, func);
        return this;
    }

    @Override
    public DOption add(EventType eventType, String jsText) {
        super.add(eventType, jsText);
        return this;
    }

    @Override
    public DOption addBr() {
        super.addBr();
        return this;
    }

    @Override
    public DOption addBr(int howMany) {
        super.addBr(howMany);
        return this;
    }

    @Override
    public DOption addHtmlClassName(String className) {
        super.addHtmlClassName(className);
        return this;
    }

    @Override
    public DOption addHtmlClassName(CssClassConstant ccc) {
        super.addHtmlClassName(ccc);
        return this;
    }

    @Override
    public DOption jif(String jif) {
        super.jif(jif);
        return this;
    }
}

