/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.binding;

import java.lang.reflect.Constructor;
import org.eclipse.vjet.dsf.common.binding.BaseValueBinding;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.util.ValueHelper;

public class SimpleValueBinding<T>
extends BaseValueBinding<T>
implements IValueBinding<T> {
    private static final long serialVersionUID = 1L;
    private T m_value = null;

    public SimpleValueBinding(Class<T> valueType) {
        super(valueType);
    }

    public SimpleValueBinding(Class<T> valueType, T value) {
        this(valueType);
        this.setValue(value);
    }

    @Override
    public void setValue(T value) {
        this.m_value = value;
    }

    @Override
    public T getValue() {
        return this.m_value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IValueBinding)) {
            return false;
        }
        IValueBinding that = (IValueBinding)obj;
        if (this.m_value == null) {
            return that.getValue() == null;
        }
        return this.m_value.equals(that.getValue());
    }

    public int hashCode() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.hashCode();
    }

    public Object clone() {
        try {
            Constructor<?> cs = this.getClass().getDeclaredConstructor(Class.class, Object.class);
            Object[] args = new Object[]{this.getValueType(), this.cloneValue()};
            return cs.newInstance(args);
        }
        catch (Exception exception) {
            throw new DsfRuntimeException("Unable to clone() ValueDataSource");
        }
    }

    public String toString() {
        return "{value: " + ValueHelper.toString(this.getValue()) + ", type: " + this.getValueType() + "}";
    }

    private Object cloneValue() {
        return this.m_value;
    }
}

