/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.context.subctx.browser.internal;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.vjet.dsf.common.context.subctx.browser.BrowserEnum;
import org.eclipse.vjet.dsf.common.context.subctx.browser.OsEnum;

public class BrowserSniffingUtils {
    private String m_browserName = "Unknown/0.0 (compatible; UNKNOWN 0.0; UNKNOWN OS 0.0)";
    public static final String UNKNOWN = "Unknown";
    public static final String FIREFOX = "FIREFOX";
    public static final String FIREFOX_HTTP_ONLY_INITIAL_VERSION = "2.0.0.5";
    private boolean m_mozillaBrowser = false;
    private String m_browserMajorVersion = null;
    private String m_browserMinorVersion = null;
    private double m_browserFullVersion = -1.0;
    Map m_browserMap = new HashMap();
    Map m_osNameMap = new HashMap();

    public BrowserSniffingUtils(String theBrowserName) {
        BrowserEnum browser;
        if (theBrowserName != null) {
            this.m_browserName = theBrowserName.toUpperCase();
        }
        ListIterator iter = OsEnum.getIterator(OsEnum.class);
        while (iter.hasNext()) {
            OsEnum os = (OsEnum)((Object)iter.next());
            if (this.m_browserName.indexOf(os.getName()) == -1) continue;
            this.m_osNameMap.put(os, os);
        }
        iter = BrowserEnum.getIterator(BrowserEnum.class);
        while (iter.hasNext()) {
            browser = (BrowserEnum)((Object)iter.next());
            if (this.m_browserName.indexOf(browser.getName()) == -1) continue;
            if (browser == BrowserEnum.MOZILLA) {
                this.m_mozillaBrowser = true;
                continue;
            }
            this.m_browserMap.put(browser, browser);
        }
        while (iter.hasNext()) {
            browser = (BrowserEnum)((Object)iter.next());
            if (browser != BrowserEnum.MOZILLA) continue;
            this.m_mozillaBrowser = true;
            break;
        }
        this.m_browserFullVersion = this.getFullBrowserVersionNumber();
        this.m_browserMajorVersion = this.getBrowserMajorVersion();
        this.m_browserMinorVersion = this.getBrowserMinorVersion();
    }

    public boolean isMSIE() {
        return !this.isOpera() && !this.isWebTV() && (this.m_browserMap.get((Object)BrowserEnum.MSIE) != null || this.m_browserMap.get((Object)BrowserEnum.INTERNET_EXPLORER) != null);
    }

    public boolean isNetscape() {
        return !this.isMSIE() && !this.isOpera() && !this.isWebTV() && !this.isSafari() && (this.m_mozillaBrowser || this.m_browserMap.get((Object)BrowserEnum.NETSCAPE) != null);
    }

    public boolean isNetscapeOnly() {
        return this.m_browserMap.get((Object)BrowserEnum.NETSCAPE) != null;
    }

    public boolean isMozillaOnly() {
        return !this.isMSIE() && !this.isOpera() && !this.isWebTV() && !this.isSafari() && !this.isNetscapeOnly() && this.m_mozillaBrowser;
    }

    public boolean isFirefoxVersionCompatible(String comparedVersion) {
        String firefoxVersion;
        if (this.m_browserName.contains(FIREFOX) && !(firefoxVersion = this.getFirefoxVersion()).equals("0")) {
            String[] st = firefoxVersion.split("[\\.\\+\\s]");
            String[] stCompared = comparedVersion.split("\\.");
            int i = 0;
            while (i < stCompared.length) {
                int verCompared = Integer.parseInt(stCompared[i]);
                if (i < st.length) {
                    int ver = 0;
                    try {
                        ver = Integer.parseInt(st[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ver = 0;
                    }
                    if (ver < verCompared) {
                        return false;
                    }
                    if (ver > verCompared) {
                        return true;
                    }
                } else {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private String getFirefoxVersion() {
        int startIndex;
        String versionString = "0";
        int fireFoxPosition = this.m_browserName.indexOf(FIREFOX);
        if (fireFoxPosition != -1 && (startIndex = fireFoxPosition + FIREFOX.length() + 1) < this.m_browserName.length()) {
            versionString = this.m_browserName.substring(startIndex).trim();
        }
        return versionString;
    }

    public int getMozillaLevel() {
        return (int)this.getFullBrowserVersionNumber();
    }

    private double parseFineLevel(String identifier1, String identifier2) {
        try {
            char trailingChar;
            int startIndex = this.m_browserName.indexOf(identifier1) + identifier1.length();
            int endIndex = this.m_browserName.indexOf(identifier2, startIndex);
            while (!Character.isDigit(trailingChar = this.m_browserName.charAt(endIndex))) {
                --endIndex;
            }
            if (startIndex == endIndex) {
                endIndex = this.m_browserName.length() - 1;
            }
            String numString = this.m_browserName.substring(startIndex, endIndex + 1);
            return Double.parseDouble(numString);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public String getBrowserMajorVersion() {
        if (this.m_browserMajorVersion != null) {
            return this.m_browserMajorVersion;
        }
        if (this.isNetscape() || this.isWebTV() || this.isSafari()) {
            return this.getDottedMajorVersion();
        }
        return this.getMajorVersion(this.getNonDottedFineBrowserVersion());
    }

    public String getBrowserMinorVersion() {
        if (this.m_browserMinorVersion != null) {
            return this.m_browserMinorVersion;
        }
        if (this.isNetscape() || this.isWebTV() || this.isSafari()) {
            return this.getDottedMinorVersion();
        }
        return this.getMinorVersion(this.getNonDottedFineBrowserVersion());
    }

    public double getNonDottedFineBrowserVersion() {
        double ver = 0.0;
        if (this.isMSIE()) {
            ver = this.parseFineLevel("MSIE ", ";");
            if (ver <= 0.0) {
                ver = this.parseFineLevel("MSIE ", " ");
            }
        } else if (this.isMozillaOnly()) {
            ver = this.parseFineLevel("MOZILLA/", " ");
        } else if (this.isOpera()) {
            if (this.m_browserName.indexOf("OPERA/") != -1) {
                ver = this.parseFineLevel("OPERA/", " ");
                if (ver <= 0.0) {
                    ver = this.parseFineLevel("OPERA/", ";");
                }
            } else if (this.m_browserName.indexOf("OPERA ") != -1) {
                ver = this.parseFineLevel("OPERA ", " ");
            }
        } else if (this.isSafari()) {
            ver = this.parseFineLevel("SAFARI/", "");
        }
        return ver;
    }

    private String getMajorVersion(double ver) {
        String ret = UNKNOWN;
        if (ver > 0.0) {
            ret = "" + (int)ver;
        }
        return ret;
    }

    private String getMinorVersion(double ver) {
        String ret = String.valueOf(ver);
        int dot = ret.indexOf(".");
        if ((ret = ret.substring(dot + 1)).length() > 2) {
            ret = ret.substring(0, 2);
        }
        return ret;
    }

    public String getBrowserOS() {
        String ret = UNKNOWN;
        if (this.m_browserName.indexOf("SUNOS") != -1) {
            ret = "SunOS";
        } else if (this.m_browserName.indexOf("LINUX") != -1) {
            ret = "Linux";
        } else if (this.m_browserName.indexOf("WINDOWS") != -1) {
            ret = "Windows";
        } else if (this.m_browserName.indexOf("WIN95") != -1) {
            ret = "Win95";
        } else if (this.m_browserName.indexOf("WIN98") != -1) {
            ret = "Win98";
        } else if (this.m_browserName.indexOf("WINNT") != -1) {
            ret = "WinNT";
        } else if (this.m_browserName.indexOf("MAC") != -1) {
            ret = "Mac";
        } else if (this.m_browserName.indexOf("HP-UX") != -1) {
            ret = "HP-UX";
        } else if (this.m_browserName.indexOf("OPENBSD") != -1) {
            ret = "OpenBSD";
        }
        return ret;
    }

    private String parseMajorVersion(String identifier1, String identifier2) {
        try {
            int startIndex = this.m_browserName.indexOf(identifier1) + identifier1.length();
            int endIndex = this.m_browserName.indexOf(identifier2, startIndex);
            String numString = this.m_browserName.substring(startIndex, endIndex);
            return numString;
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }

    private String parseMinorVersion(String identifier1, String identifier2) {
        String minString = UNKNOWN;
        try {
            try {
                int startIndex = this.m_browserName.indexOf(identifier1) + identifier1.length();
                int endIndex = this.m_browserName.indexOf(identifier2, startIndex);
                if (endIndex + 2 <= this.m_browserName.length() - 1) {
                    minString = this.m_browserName.charAt(endIndex + 2) != ' ' && this.m_browserName.charAt(endIndex + 2) != ';' && this.m_browserName.charAt(endIndex + 2) != '.' ? this.m_browserName.substring(endIndex + 1, endIndex + 3) : this.m_browserName.substring(endIndex + 1, endIndex + 2);
                } else if (endIndex + 1 <= this.m_browserName.length() - 1) {
                    minString = this.m_browserName.substring(endIndex + 1, endIndex + 2);
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {}
        return minString;
    }

    private String getDottedMajorVersion() {
        String ret = UNKNOWN;
        if (this.m_browserName.indexOf("NETSCAPE/") != -1) {
            ret = this.parseMajorVersion("NETSCAPE/", ".");
        } else if (this.m_browserName.indexOf("NETSCAPE7/") != -1) {
            ret = this.parseMajorVersion("NETSCAPE7/", ".");
        } else if (this.m_browserName.indexOf("NETSCAPE6/") != -1) {
            ret = this.parseMajorVersion("NETSCAPE6/", ".");
        } else if (this.isWebTV()) {
            ret = this.parseMajorVersion("WEBTV/", ".");
        } else if (this.isSafari()) {
            ret = this.parseMajorVersion("SAFARI/", ".");
        } else if (this.m_browserName.indexOf("NETSCAPE") == -1 && this.m_browserName.indexOf("MOZILLA/") != -1) {
            ret = this.parseMajorVersion("MOZILLA/", ".");
        }
        return ret;
    }

    private String getDottedMinorVersion() {
        String ret = UNKNOWN;
        if (this.m_browserName.indexOf("NETSCAPE/") != -1) {
            ret = this.parseMinorVersion("NETSCAPE/", ".");
        } else if (this.m_browserName.indexOf("NETSCAPE7/") != -1) {
            ret = this.parseMinorVersion("NETSCAPE7/", ".");
        } else if (this.m_browserName.indexOf("NETSCAPE6/") != -1) {
            ret = this.parseMinorVersion("NETSCAPE6/", ".");
        } else if (this.isWebTV()) {
            ret = this.parseMinorVersion("WEBTV/", ".");
        } else if (this.isSafari()) {
            ret = this.parseMinorVersion("SAFARI/", ".");
        } else if (this.m_browserName.indexOf("NETSCAPE") == -1 && this.m_browserName.indexOf("MOZILLA/") != -1) {
            ret = this.parseMinorVersion("MOZILLA/", ".");
        }
        return ret;
    }

    public String getBrowserVersion() {
        return String.valueOf(this.getBrowserMajorVersion()) + "." + this.getBrowserMinorVersion();
    }

    public double getFullBrowserVersionNumber() {
        if (this.m_browserFullVersion != -1.0) {
            return this.m_browserFullVersion;
        }
        double finalValue = 0.0;
        try {
            finalValue = this.isNetscapeOnly() || this.isWebTV() || this.isSafari() ? Double.parseDouble(this.getBrowserMajorVersion()) + this.convertBrowserMinorVersion() : this.getNonDottedFineBrowserVersion();
        }
        catch (Exception exception) {}
        return finalValue;
    }

    public double convertBrowserMinorVersion() {
        double finalValue = 0.0;
        try {
            String minorVersionStr = this.getBrowserMinorVersion();
            if (minorVersionStr.startsWith("0")) {
                return finalValue;
            }
            minorVersionStr = "0." + minorVersionStr;
            finalValue = Double.parseDouble(minorVersionStr);
        }
        catch (Exception exception) {}
        return finalValue;
    }

    boolean isMozillaBrowser() {
        return this.m_mozillaBrowser;
    }

    public boolean isWebTV() {
        return this.m_browserMap.get((Object)BrowserEnum.WEBTV) != null;
    }

    public boolean isSafari() {
        return this.m_browserMap.get((Object)BrowserEnum.SAFARI) != null;
    }

    public boolean isOpera() {
        return this.m_browserMap.get((Object)BrowserEnum.OPERA) != null;
    }

    public String getBrowserVendor() {
        String ret = UNKNOWN;
        if (this.isMSIE()) {
            ret = "MSIE";
        } else if (this.isNetscapeOnly()) {
            ret = "Netscape";
        } else if (this.isMozillaOnly()) {
            ret = "Mozilla";
        } else if (this.isOpera()) {
            ret = "Opera";
        } else if (this.isWebTV()) {
            ret = "WebTV";
        } else if (this.isSafari()) {
            ret = "Safari";
        } else if (this.isAOL()) {
            ret = "AOL";
        }
        return ret;
    }

    public boolean isAOL() {
        return this.m_browserMap.get((Object)BrowserEnum.AOL) != null;
    }

    public String getBrowserVendorForVI() {
        String ret = UNKNOWN;
        if (this.isMSIE()) {
            ret = BrowserEnum.MSIE.getName();
        } else if (this.isNetscapeOnly()) {
            ret = BrowserEnum.NETSCAPE.getName();
        } else if (this.isMozillaOnly()) {
            ret = BrowserEnum.MOZILLA.getName();
        } else if (this.isOpera()) {
            ret = BrowserEnum.OPERA.getName();
        } else if (this.isWebTV()) {
            ret = BrowserEnum.WEBTV.getName();
        } else if (this.isSafari()) {
            ret = BrowserEnum.SAFARI.getName();
        } else if (this.isAOL()) {
            ret = BrowserEnum.AOL.getName();
        }
        return ret;
    }

    static class BrowserFlags {
        static int ALLBROWSERS = 0;
        static int WEBTV = 1;
        static int OPERA = 2;
        static int NETSCAPE_BEFORE_3 = 4;
        static int NETSCAPE_3 = 8;
        static int NETSCAPE_AFTER_3 = 16;
        static int NETSCAPE_5 = 32;
        static int NETSCAPE_6 = 64;
        static int MSIE_BEFORE_3 = 128;
        static int MSIE_AFTER_3 = 256;
        static int MSIE_5 = 512;
        static int MSIE_55 = 1024;
        static int MSIE_6 = 2048;
        static int AOL = 4096;

        BrowserFlags() {
        }
    }
}

