/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.statistics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.vjet.dsf.common.statistics.BizMoHistogram;
import org.eclipse.vjet.dsf.common.statistics.BizOpHistogram;
import org.eclipse.vjet.dsf.common.statistics.ComponentHistogram;
import org.eclipse.vjet.dsf.common.statistics.ContentHistogram;
import org.eclipse.vjet.dsf.common.statistics.CssHistogram;
import org.eclipse.vjet.dsf.common.statistics.EsfTemplateFailureHistogram;
import org.eclipse.vjet.dsf.common.statistics.EsfTemplateHistogram;
import org.eclipse.vjet.dsf.common.statistics.IV4Statistics;
import org.eclipse.vjet.dsf.common.statistics.ImageHistogram;
import org.eclipse.vjet.dsf.common.statistics.JavascriptHistogram;
import org.eclipse.vjet.dsf.common.statistics.LinkHistogram;
import org.eclipse.vjet.dsf.common.statistics.UnspecdCmpStatistics;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.util.XmlWriterHelper;

public class V4StatisticsContainer
implements IV4Statistics {
    private static final V4StatisticsContainer s_instance = new V4StatisticsContainer();
    private ConcurrentMap<String, IV4Statistics> m_stat;
    private ContentHistogram m_contentHisto;
    private ComponentHistogram m_componentHisto;
    private JavascriptHistogram m_jsHisto;
    private CssHistogram m_cssHisto;
    private ImageHistogram m_imgHisto;
    private LinkHistogram m_lnkHisto;
    private EsfTemplateHistogram m_esfTemplateHisto;
    private EsfTemplateFailureHistogram m_esfTemplateFailureHisto;
    private BizMoHistogram m_bizMoHisto;
    private BizOpHistogram m_bizOpHisto;
    private UnspecdCmpStatistics m_unspecdInfo;
    private static final int THRESHOLD = 500;
    private final AtomicInteger m_monitor = new AtomicInteger(0);

    public static final V4StatisticsContainer getInstance() {
        return s_instance;
    }

    private V4StatisticsContainer() {
        this.m_stat = new ConcurrentHashMap<String, IV4Statistics>();
        this.m_contentHisto = new ContentHistogram();
        this.add("v4-content", this.m_contentHisto);
        this.m_componentHisto = new ComponentHistogram();
        this.add("v4-component", this.m_componentHisto);
        this.m_jsHisto = new JavascriptHistogram();
        this.add("v4-js", this.m_jsHisto);
        this.m_cssHisto = new CssHistogram();
        this.add("v4-css", this.m_cssHisto);
        this.m_imgHisto = new ImageHistogram();
        this.add("v4-image", this.m_imgHisto);
        this.m_lnkHisto = new LinkHistogram();
        this.add("v4-link", this.m_lnkHisto);
        this.m_esfTemplateHisto = new EsfTemplateHistogram();
        this.add("esf-template", this.m_esfTemplateHisto);
        this.m_esfTemplateFailureHisto = new EsfTemplateFailureHistogram();
        this.add("esf-template-failure", this.m_esfTemplateFailureHisto);
        this.m_bizMoHisto = new BizMoHistogram();
        this.add("bizmo", this.m_bizMoHisto);
        this.m_bizOpHisto = new BizOpHistogram();
        this.add("bizop", this.m_bizOpHisto);
        this.m_unspecdInfo = new UnspecdCmpStatistics();
        this.add("v4-unspec", this.m_unspecdInfo);
    }

    public int getIncrement() {
        return 500;
    }

    public int getMonitor() {
        return this.m_monitor.get();
    }

    public void incrementMonitor() {
        this.m_monitor.incrementAndGet();
    }

    public boolean doStatistics() {
        return this.m_monitor.get() % 500 == 0;
    }

    public ContentHistogram getContentHistogram() {
        return this.m_contentHisto;
    }

    public ComponentHistogram getComponentHistogram() {
        return this.m_componentHisto;
    }

    public JavascriptHistogram getJavascriptHistogram() {
        return this.m_jsHisto;
    }

    public CssHistogram getCssHistogram() {
        return this.m_cssHisto;
    }

    public ImageHistogram getImageHistogram() {
        return this.m_imgHisto;
    }

    public LinkHistogram getLinkHistogram() {
        return this.m_lnkHisto;
    }

    public EsfTemplateHistogram getEsfTemplateHistogram() {
        return this.m_esfTemplateHisto;
    }

    public EsfTemplateFailureHistogram getEsfTemplateFailureHistogram() {
        return this.m_esfTemplateFailureHisto;
    }

    public BizMoHistogram getBizMoHistogram() {
        return this.m_bizMoHisto;
    }

    public BizOpHistogram getBizOpHistogram() {
        return this.m_bizOpHisto;
    }

    public void add(String name, IV4Statistics stat) {
        this.m_stat.put(name, stat);
    }

    public IV4Statistics get(String name) {
        return (IV4Statistics)this.m_stat.get(name);
    }

    @Override
    public String getName() {
        return "V4_Statistics";
    }

    @Override
    public void reset() {
        for (IV4Statistics value : this.m_stat.values()) {
            value.reset();
        }
        this.m_stat.clear();
    }

    @Override
    public DElement toXml() {
        DElement stat = new DElement("statistics");
        for (IV4Statistics value : this.m_stat.values()) {
            stat.add(value.toXml());
        }
        return stat;
    }

    @Override
    public String asString() {
        return XmlWriterHelper.asString(this.toXml());
    }

    public UnspecdCmpStatistics getUnspecdInfo() {
        return this.m_unspecdInfo;
    }
}

