/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.util.Vector;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DElementConstructor;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class DomDocumentBuilderBase
implements ContentHandler,
LexicalHandler {
    protected DDocument m_document;
    protected DElement m_current;
    private boolean m_ignoreWhitespace = true;
    private boolean m_ignoreEmptyLines = true;
    private boolean m_done = true;
    protected Vector<?> m_preRootNodes;

    protected abstract DElementConstructor getElementConstructor();

    protected abstract DDocument createNewDocument();

    protected abstract DElement getRootElement();

    @Override
    public void startDocument() throws SAXException {
        if (!this.m_done) {
            this.chuck("startDocument already called.");
        }
        this.m_document = null;
        this.m_done = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.m_document == null) {
            this.chuck("Document never started or missing document element.");
        }
        if (this.m_current != null) {
            this.chuck("Document ended before end of document element.");
        }
        this.m_current = null;
        this.m_done = true;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName == null) {
            this.chuck("Tag name is null.");
        }
        if (this.m_document == null) {
            this.m_document = this.createNewDocument();
            this.m_current = this.getRootElement();
            if (this.m_current == null) {
                this.chuck("No document element (page) for this document");
            }
            if (this.m_preRootNodes != null) {
                int i = this.m_preRootNodes.size();
                while (i-- > 0) {
                    this.m_document.insertBefore((Node)this.m_preRootNodes.elementAt(i), this.m_current);
                }
                this.m_preRootNodes = null;
            }
        } else {
            if (this.m_current == null) {
                this.chuck("startElement called after end of document element.");
            }
            DElement node = this.getElementConstructor().domCreateDynamicElement(localName);
            if (namespaceURI != null && namespaceURI.length() > 0) {
                int prefixIdx = qName.indexOf(":");
                if (prefixIdx != -1) {
                    node.setDsfNamespace(DNamespace.getNamespace(qName.substring(0, prefixIdx), namespaceURI));
                } else {
                    node.setDsfNamespace(DNamespace.getNamespace(null, namespaceURI));
                }
            }
            this.m_current.add(node);
            this.m_current = node;
        }
        this.addAttributesToElement(atts);
    }

    protected void addAttributesToElement(Attributes atts) {
        if (atts != null) {
            int i = 0;
            while (i < atts.getLength()) {
                String name = atts.getLocalName(i);
                String value = atts.getValue(i);
                if ("id".equalsIgnoreCase(name)) {
                    DAttr attr = (DAttr)this.m_document.createAttribute(name);
                    attr.setValue(value);
                    this.m_current.setAttributeNode(attr);
                    this.m_current.setIdAttribute(name, true);
                } else {
                    this.m_current.setAttribute(name, value);
                }
                ++i;
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.m_current == null) {
            this.chuck("endElement called with no current node.");
        }
        if (this.m_current.getNamespaceURI() == null) {
            if (!this.m_current.getNodeName().equalsIgnoreCase(localName)) {
                this.chuck("mismatch in closing tag name " + localName + "\n" + this.m_current.getNodeName());
            }
        } else if (!this.m_current.getNodeName().equalsIgnoreCase(qName)) {
            this.chuck("mismatch in closing tag name " + qName + "\n" + this.m_current.getNodeName());
        }
        this.endElementInternal();
        this.m_current = this.m_current.getParentNode().getNodeType() == 9 ? null : (DElement)this.m_current.getParentNode();
    }

    protected void endElementInternal() {
    }

    public void characters(String text) throws SAXException {
        this.addText(text);
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        this.addText(new String(text, start, length));
    }

    public boolean isIngoringEmptyLines() {
        return this.m_ignoreEmptyLines;
    }

    public void setIgnoreEmptyLines(boolean ignore) {
        this.m_ignoreEmptyLines = ignore;
    }

    public boolean isIngoringWhitespace() {
        return this.m_ignoreWhitespace;
    }

    public void setIgnoreWhiteSpace(boolean ignore) {
        this.m_ignoreWhitespace = ignore;
    }

    @Override
    public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
        if (!this.m_ignoreWhitespace) {
            this.addText(new String(text, start, length));
        }
    }

    private void addText(String text) throws SAXException {
        String trim;
        if (this.m_current == null) {
            throw new SAXException("character data found outside of element.");
        }
        if (this.m_ignoreEmptyLines && (trim = text.trim()).equals("")) {
            return;
        }
        Node child = this.m_current.getLastChild();
        if (child instanceof DText) {
            ((DText)child).appendData(text);
        } else {
            this.m_current.add(text);
        }
    }

    @Override
    public void processingInstruction(String target, String instruction) throws SAXException {
    }

    public DElement getCurrentElement() {
        return this.m_current;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uti) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] text, int start, int length) throws SAXException {
        if (this.m_document == null) {
            return;
        }
        this.m_current.appendChild(this.m_document.createComment(new String(text, start, length)));
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    private void chuck(String msg) throws SAXException {
        throw new SAXException(msg);
    }
}

