/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom.util;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriterOptions;

public class DomWriterCtx {
    private static final int STRING_WRITER_INIT_SIZE = 128;
    private int m_flags;
    private static final short FLAG_OPTIMIZATION = 1;
    private static final short FLAG_ADD_LINE_NUM = 2;
    private static final short FLAG_RENDER_XML_DOC = 4;
    private static final short FLAG_RENDER_NS = 8;
    private static final short FLAG_TRIM_DTEXT = 16;
    private Writer m_writer;
    private IIndenter m_indenter;

    public DomWriterCtx() {
        this(DomWriterCtx.createWriter(), IIndenter.COMPACT);
    }

    public DomWriterCtx(Writer writer, IIndenter indenter) {
        if (writer == null) {
            throw new DsfRuntimeException("Writer is null");
        }
        if (indenter == null) {
            throw new DsfRuntimeException("indenter is null");
        }
        this.m_writer = writer;
        this.m_indenter = indenter;
    }

    static XmlStreamWriterOptions createDefaultStreamOpt() {
        return new XmlStreamWriterOptions(DomWriterCtx.createWriter(), IIndenter.COMPACT, true);
    }

    public static Writer createWriter() {
        return new StringWriter(128);
    }

    public char[][] getNotEscapeTags() {
        return null;
    }

    public boolean isOptimization() {
        return (this.m_flags & 1) != 0;
    }

    public DomWriterCtx setOptimization(boolean value) {
        this.m_flags = value ? this.m_flags | 1 : this.m_flags & 0xFFFFFFFE;
        return this;
    }

    public boolean isAddLineNumber() {
        return (this.m_flags & 2) != 0;
    }

    public DomWriterCtx setAddLineNumber(boolean value) {
        this.m_flags = value ? this.m_flags | 2 : this.m_flags & 0xFFFFFFFD;
        return this;
    }

    public DomWriterCtx setWriter(Writer writer) {
        this.m_writer = writer;
        return this;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public DomWriterCtx setIndenter(IIndenter indenter) {
        this.m_indenter = indenter;
        return this;
    }

    public IIndenter getIndenter() {
        return this.m_indenter;
    }

    public boolean isRenderXmlDoc() {
        return (this.m_flags & 4) != 0;
    }

    public DomWriterCtx setRenderXmlDoc(boolean value) {
        this.m_flags = value ? this.m_flags | 4 : this.m_flags & 0xFFFFFFFB;
        return this;
    }

    public boolean isRenderNS() {
        return (this.m_flags & 8) != 0;
    }

    public DomWriterCtx setTrimDText(boolean value) {
        this.m_flags = value ? this.m_flags | 0x10 : this.m_flags & 0xFFFFFFEF;
        return this;
    }

    public boolean isTrimDText() {
        return (this.m_flags & 0x10) != 0;
    }

    public DomWriterCtx setRenderNS(boolean value) {
        this.m_flags = value ? this.m_flags | 8 : this.m_flags & 0xFFFFFFF7;
        return this;
    }

    public String toString() {
        Z z = new Z();
        z.format("render XML doc", this.isRenderXmlDoc());
        z.format("render NS", this.isRenderNS());
        z.format("add line numbers", this.isAddLineNumber());
        z.format("trim DText", this.isTrimDText());
        z.format("optimize", this.isOptimization());
        if (this.m_indenter != null) {
            z.format("indenter", this.m_indenter.getClass());
        }
        if (this.m_writer != null) {
            z.format("writer", this.m_writer.getClass());
        }
        return z.toString();
    }
}

