/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.mod.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.mod.internal.debug.ui.ErrorDialogWithToggle;
import org.eclipse.dltk.mod.internal.debug.ui.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class HotCodeReplaceErrorDialog
extends ErrorDialogWithToggle {
    protected IDebugTarget target;
    protected int TERMINATE_ID = 14;
    protected int DISCONNECT_ID = this.TERMINATE_ID + 1;
    protected int RESTART_ID = this.TERMINATE_ID + 2;

    public HotCodeReplaceErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, String preferenceKey, String toggleMessage, IPreferenceStore store, IDebugTarget target) {
        super(parentShell, dialogTitle, message, status, preferenceKey, toggleMessage, store);
        this.target = target;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(Messages.HotCodeReplaceErrorDialog_continue);
        boolean canTerminate = this.target.canTerminate();
        boolean canDisconnect = this.target.canDisconnect();
        if (canTerminate) {
            this.createButton(parent, this.TERMINATE_ID, Messages.HotCodeReplaceErrorDialog_terminate, false);
        }
        if (canDisconnect) {
            this.createButton(parent, this.DISCONNECT_ID, Messages.HotCodeReplaceErrorDialog_disconnect, false);
        }
        if (canTerminate && !canDisconnect) {
            this.createButton(parent, this.RESTART_ID, Messages.HotCodeReplaceErrorDialog_restart, false);
        }
    }

    @Override
    protected void buttonPressed(final int id) {
        if (id == this.TERMINATE_ID || id == this.DISCONNECT_ID || id == this.RESTART_ID) {
            DebugException[] ex = new DebugException[1];
            Object[] operation = new String[1];
            ex[0] = null;
            Runnable r = new Runnable((String[])operation, ex){
                private final /* synthetic */ String[] val$operation;
                private final /* synthetic */ DebugException[] val$ex;
                {
                    this.val$operation = stringArray;
                    this.val$ex = debugExceptionArray;
                }

                @Override
                public void run() {
                    try {
                        if (id == HotCodeReplaceErrorDialog.this.TERMINATE_ID) {
                            this.val$operation[0] = Messages.HotCodeReplaceErrorDialog_terminate2;
                            HotCodeReplaceErrorDialog.this.target.terminate();
                        } else if (id == HotCodeReplaceErrorDialog.this.DISCONNECT_ID) {
                            this.val$operation[0] = Messages.HotCodeReplaceErrorDialog_disconnect2;
                            HotCodeReplaceErrorDialog.this.target.disconnect();
                        } else {
                            this.val$operation[0] = Messages.HotCodeReplaceErrorDialog_restart2;
                            ILaunch launch = HotCodeReplaceErrorDialog.this.target.getLaunch();
                            launch.terminate();
                            ILaunchConfiguration config = launch.getLaunchConfiguration();
                            if (config != null && config.exists()) {
                                DebugUITools.launch((ILaunchConfiguration)config, (String)launch.getLaunchMode());
                            }
                        }
                    }
                    catch (DebugException e) {
                        this.val$ex[0] = e;
                    }
                }
            };
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
            if (ex[0] != null) {
                DLTKDebugUIPlugin.errorDialog(MessageFormat.format(Messages.HotCodeReplaceErrorDialog_failed, operation), ex[0].getStatus());
            }
            this.okPressed();
        } else {
            super.buttonPressed(id);
        }
    }
}

