/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.validators.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.validators.core.IValidatorOutput;
import org.eclipse.dltk.mod.validators.core.NullValidatorOutput;
import org.eclipse.dltk.mod.validators.internal.core.ValidatorUtils;

public abstract class AbstractValidateJob
extends Job {
    private final Map byProject = new HashMap();

    public AbstractValidateJob(String jobName) {
        super(jobName);
    }

    protected abstract void invokeValidationFor(IValidatorOutput var1, IScriptProject var2, ISourceModule[] var3, IResource[] var4, IProgressMonitor var5);

    public void run(Object[] selection) {
        HashSet elements = new HashSet();
        HashSet resources = new HashSet();
        int i = 0;
        while (i < selection.length) {
            Object o = selection[i];
            ValidatorUtils.processResourcesToElements(o, elements, resources);
            ++i;
        }
        for (ISourceModule module : elements) {
            IProject project;
            IScriptProject sproject = module.getScriptProject();
            if (sproject == null || (project = sproject.getProject()) == null) continue;
            this.getProjectInfo((IProject)project).elements.add(module);
        }
        for (IResource resource : resources) {
            IProject project = resource.getProject();
            if (project == null) continue;
            this.getProjectInfo((IProject)project).resources.add(resource);
        }
        this.setRule(this.buildSchedulingRule(elements, resources));
        this.setUser(true);
        this.schedule();
    }

    private ProjectInfo getProjectInfo(IProject project) {
        ProjectInfo info = (ProjectInfo)this.byProject.get(project);
        if (info == null) {
            info = new ProjectInfo();
            this.byProject.put(project, info);
        }
        return info;
    }

    private ISchedulingRule buildSchedulingRule(Set elements, Set resources) {
        HashSet<IResource> all = new HashSet<IResource>(resources);
        for (ISourceModule module : elements) {
            IResource resource = module.getResource();
            if (resource == null) continue;
            all.add(resource);
        }
        ISchedulingRule[] rules = new ISchedulingRule[all.size()];
        all.toArray(rules);
        return MultiRule.combine((ISchedulingRule[])rules);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IValidatorOutput output = null;
        try {
            output = this.createOutput();
            for (Map.Entry entry : this.byProject.entrySet()) {
                IProject project = (IProject)entry.getKey();
                ProjectInfo info = (ProjectInfo)entry.getValue();
                this.invokeValidationFor(output, DLTKCore.create((IProject)project), info.elementsToArray(), info.resourcesToArray(), monitor);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return Status.OK_STATUS;
    }

    protected IValidatorOutput createOutput() {
        return new NullValidatorOutput();
    }

    private static class ProjectInfo {
        final List resources = new ArrayList();
        final List elements = new ArrayList();

        private ProjectInfo() {
        }

        public ISourceModule[] elementsToArray() {
            return this.elements.toArray(new ISourceModule[this.elements.size()]);
        }

        public IResource[] resourcesToArray() {
            return this.resources.toArray(new IResource[this.resources.size()]);
        }
    }
}

