/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.validators.internal.ui.popup.actions;

import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.validators.core.ISourceModuleValidator;
import org.eclipse.dltk.mod.validators.core.IValidator;
import org.eclipse.dltk.mod.validators.core.IValidatorType;
import org.eclipse.dltk.mod.validators.core.ValidatorRuntime;
import org.eclipse.dltk.mod.validators.internal.ui.popup.actions.Messages;
import org.eclipse.dltk.mod.validators.internal.ui.popup.actions.RemoveAllMarkersAction;
import org.eclipse.dltk.mod.validators.internal.ui.popup.actions.ValidateAction;
import org.eclipse.dltk.mod.validators.internal.ui.popup.actions.ValidateAllAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionGroup;

public class DLTKValidatorsActionGroup
extends ActionGroup {
    private static final boolean DEBUG = false;

    public void fillContextMenu(IMenuManager menu) {
        Object input = this.getContext().getInput();
        if (!(input instanceof IEditorInput)) {
            return;
        }
        ISourceModule element = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)((IEditorInput)input));
        if (element == null) {
            return;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
        if (toolkit == null) {
            return;
        }
        IScriptProject project = element.getScriptProject();
        if (project == null) {
            return;
        }
        IValidatorType[] validatorTypes = ValidatorRuntime.getValidatorTypes((String)toolkit.getNatureId());
        if (validatorTypes == null || validatorTypes.length == 0) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)element);
        int validatorCount = 0;
        MenuManager subMenu = new MenuManager(Messages.DLTKValidatorsEditorContextMenu_text);
        int i = 0;
        while (i < validatorTypes.length) {
            IValidator[] validators;
            IValidatorType type = validatorTypes[i];
            if (type.supports(ISourceModuleValidator.class) && (validators = type.getValidators()) != null && validators.length != 0) {
                int j = 0;
                while (j < validators.length) {
                    IValidator validator = validators[j];
                    ++validatorCount;
                    ValidateAction action = new ValidateAction(validator, (IStructuredSelection)selection);
                    action.setEnabled(validator.isValidatorValid(project));
                    subMenu.add((IAction)action);
                    ++j;
                }
            }
            ++i;
        }
        if (validatorCount != 0) {
            subMenu.add((IContributionItem)new Separator());
            subMenu.add((IAction)new RemoveAllMarkersAction((IStructuredSelection)selection));
            subMenu.add((IAction)new ValidateAllAction((IStructuredSelection)selection));
            menu.appendToGroup("additions", (IContributionItem)subMenu);
        }
    }
}

